/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.forwarding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.management.forwarding.ForwardingNotificationEvent;
import org.jppf.management.forwarding.ForwardingNotificationEventListener;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForwardingNotificationDispatcher {
    private static final Logger log = LoggerFactory.getLogger(ForwardingNotificationDispatcher.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final ForwardingNotificationEventListener[] EMPTY_LISTENERS = new ForwardingNotificationEventListener[0];
    private final BaseNodeContext node;
    private final String nodeUuid;
    private final Map<String, ForwardingNotificationHandler> handlerMap = new HashMap<String, ForwardingNotificationHandler>();
    private final List<ForwardingNotificationEventListener> listenerList = new ArrayList<ForwardingNotificationEventListener>();
    private ForwardingNotificationEventListener[] listenerArray = EMPTY_LISTENERS;
    private final Lock lock = new ReentrantLock();

    public ForwardingNotificationDispatcher(BaseNodeContext node) {
        this.node = node;
        this.nodeUuid = node.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addNotificationListener(String mBeanName) {
        this.lock.lock();
        if (this.handlerMap.containsKey(mBeanName)) {
            boolean bl = false;
            return bl;
        }
        JMXNodeConnectionWrapper jmx = this.node.getJmxConnection();
        if (jmx != null) {
            ForwardingNotificationHandler handler = new ForwardingNotificationHandler(mBeanName);
            try {
                if (debugEnabled) {
                    log.debug("mBeanName={}, handler={}", (Object)mBeanName, (Object)handler);
                }
                jmx.addNotificationListener(mBeanName, (NotificationListener)handler);
                this.handlerMap.put(mBeanName, handler);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                String format = "failed to add notification listener for node={} : exception={}";
                if (debugEnabled) {
                    log.debug("failed to add notification listener for node={} : exception={}", (Object)this.node, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    return false;
                } else {
                    log.info("failed to add notification listener for node={} : exception={}", (Object)this.node, (Object)ExceptionUtils.getMessage((Throwable)e));
                }
                return false;
            }
        }
        if (!debugEnabled) return false;
        log.debug("cannot add {} notification listener for node = {} because the jmx connection is null", (Object)mBeanName, (Object)this.node.getUuid());
        return false;
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNotificationListener(String mBeanName) {
        block10: {
            this.lock.lock();
            try {
                ForwardingNotificationHandler handler = this.handlerMap.remove(mBeanName);
                if (handler == null) {
                    boolean bl = false;
                    return bl;
                }
                JMXNodeConnectionWrapper jmx = this.node.getJmxConnection();
                if (jmx == null) break block10;
                try {
                    jmx.removeNotificationListener(mBeanName, (NotificationListener)handler);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    String message = String.format("error removing notification listener for node=%s, mBeanName=%s", this.nodeUuid, mBeanName);
                    if (debugEnabled) {
                        log.debug(message, (Throwable)e);
                    } else {
                        log.info("{} : {}", (Object)message, (Object)ExceptionUtils.getMessage((Throwable)e));
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    public boolean hasNotificationListener() {
        this.lock.lock();
        try {
            boolean bl = !this.handlerMap.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addForwardingNotificationEventListener(ForwardingNotificationEventListener listener) {
        List<ForwardingNotificationEventListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(listener);
            this.listenerArray = this.listenerList.toArray(new ForwardingNotificationEventListener[this.listenerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeForwardingNotificationEventListener(ForwardingNotificationEventListener listener) {
        List<ForwardingNotificationEventListener> list = this.listenerList;
        synchronized (list) {
            if (this.listenerList.remove(listener)) {
                this.listenerArray = this.listenerList.toArray(new ForwardingNotificationEventListener[this.listenerList.size()]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotificationEvent(String mBeanName, Notification notification) {
        ForwardingNotificationEvent event = new ForwardingNotificationEvent(this.nodeUuid, mBeanName, notification);
        ForwardingNotificationEventListener[] forwardingNotificationEventListenerArray = this.listenerList;
        synchronized (this.listenerList) {
            ForwardingNotificationEventListener[] tmp = this.listenerArray;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (ForwardingNotificationEventListener listener : tmp) {
                listener.notificationReceived(event);
            }
            return;
        }
    }

    private class ForwardingNotificationHandler
    implements NotificationListener {
        private final String mBeanName;

        public ForwardingNotificationHandler(String mBeanName) {
            this.mBeanName = mBeanName;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            try {
                if (debugEnabled) {
                    log.debug(String.format("received notification from node=%s, mbean=%s, notification=%s, handback=%s", ForwardingNotificationDispatcher.this.nodeUuid, this.mBeanName, notification, handback));
                }
                ForwardingNotificationDispatcher.this.fireNotificationEvent(this.mBeanName, notification);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

