/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.forwarding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.NodeSelectionHelper;
import org.jppf.management.NodeSelector;
import org.jppf.management.forwarding.AbstractNodeForwarding;
import org.jppf.management.forwarding.ForwardingNotificationDispatcher;
import org.jppf.management.forwarding.ForwardingNotificationEvent;
import org.jppf.management.forwarding.ForwardingNotificationEventListener;
import org.jppf.management.forwarding.JPPFNodeForwardingNotification;
import org.jppf.management.forwarding.NodeForwardingHelper;
import org.jppf.management.forwarding.NotificationListenerWrapper;
import org.jppf.server.JPPFDriver;
import org.jppf.server.event.NodeConnectionEvent;
import org.jppf.server.event.NodeConnectionListener;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingNotificationManager
implements NodeConnectionListener,
ForwardingNotificationEventListener {
    private static final Logger log = LoggerFactory.getLogger(ForwardingNotificationManager.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final AbstractNodeForwarding forwarder;
    private Map<String, ForwardingNotificationDispatcher> nodeMap = new HashMap<String, ForwardingNotificationDispatcher>();
    private Map<String, CollectionMap<String, NotificationListenerWrapper>> clientMap = new HashMap<String, CollectionMap<String, NotificationListenerWrapper>>();
    private final Lock lock = new ReentrantLock();
    private NodeForwardingHelper forwardingHelper = NodeForwardingHelper.getInstance();
    final NodeSelectionHelper selectionHelper;
    final JPPFDriver driver;

    public ForwardingNotificationManager(AbstractNodeForwarding forwarder) {
        this.forwarder = forwarder;
        this.selectionHelper = forwarder.getSelectionHelper();
        this.driver = forwarder.driver;
        this.driver.getInitializer().getNodeConnectionEventHandler().addProvider(this);
    }

    public void addNotificationListener(String listenerID, NodeSelector selector, String mBeanName) {
        this.addNotificationListener(new NotificationListenerWrapper(listenerID, selector, mBeanName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotificationListener(NotificationListenerWrapper wrapper) {
        if (debugEnabled) {
            log.debug("adding notification listener {}", (Object)wrapper);
        }
        NodeSelector selector = wrapper.getSelector();
        Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector);
        if (debugEnabled) {
            log.debug("found {} nodes", (Object)nodes.size());
        }
        this.lock.lock();
        try {
            this.forwardingHelper.setListener(wrapper.getListenerID(), wrapper);
            for (BaseNodeContext node : nodes) {
                this.addNotificationListener(node, wrapper);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addNotificationListener(BaseNodeContext node, NotificationListenerWrapper wrapper) {
        ForwardingNotificationDispatcher dispatcher;
        boolean wasNull;
        String uuid = node.getUuid();
        String mbean = wrapper.getMBeanName();
        if (debugEnabled) {
            log.debug("adding notification listener for node={} : {}", (Object)uuid, (Object)wrapper);
        }
        boolean bl = wasNull = (dispatcher = this.nodeMap.get(uuid)) == null;
        if (wasNull) {
            dispatcher = new ForwardingNotificationDispatcher(node);
        }
        if (dispatcher.addNotificationListener(mbean)) {
            ArrayListHashMap map;
            if (wasNull) {
                this.nodeMap.put(uuid, dispatcher);
                dispatcher.addForwardingNotificationEventListener(this);
            }
            if ((map = this.clientMap.get(uuid)) == null) {
                map = new ArrayListHashMap();
                this.clientMap.put(uuid, (CollectionMap<String, NotificationListenerWrapper>)map);
            }
            map.putValue((Object)mbean, (Object)wrapper);
        }
    }

    public void removeNotificationListener(String listenerID) throws ListenerNotFoundException {
        NotificationListenerWrapper wrapper;
        if (debugEnabled) {
            log.debug("removing notification listeners for listenerID = {}", (Object)listenerID);
        }
        if ((wrapper = this.forwardingHelper.removeListener(listenerID)) == null) {
            throw new ListenerNotFoundException("could not find listener with id=" + listenerID);
        }
        this.removeNotificationListener(wrapper);
    }

    public void removeNotificationListener(NotificationListenerWrapper wrapper) throws ListenerNotFoundException {
        if (debugEnabled) {
            log.debug("removing notification listeners for {}", (Object)wrapper);
        }
        NodeSelector selector = wrapper.getSelector();
        Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector);
        Runnable r = () -> {
            this.lock.lock();
            try {
                for (BaseNodeContext node : nodes) {
                    this.removeNotificationListener(node, wrapper);
                }
            }
            finally {
                this.lock.unlock();
            }
        };
        ThreadUtils.startThread((Runnable)r, (String)("removeNotificationListener(" + wrapper + ")"));
    }

    private void removeNotificationListener(BaseNodeContext node, NotificationListenerWrapper wrapper) {
        if (debugEnabled) {
            log.debug("removing notification listener {} for node {}", (Object)wrapper, (Object)node);
        }
        String mbean = wrapper.getMBeanName();
        String uuid = node.getUuid();
        ForwardingNotificationDispatcher dispatcher = this.nodeMap.get(uuid);
        if (dispatcher == null) {
            return;
        }
        CollectionMap<String, NotificationListenerWrapper> map = this.clientMap.get(uuid);
        if (map != null) {
            map.removeValue((Object)mbean, (Object)wrapper);
            if (!map.containsKey((Object)mbean)) {
                dispatcher.removeNotificationListener(mbean);
            }
            if (map.isEmpty()) {
                this.clientMap.remove(uuid);
            }
        }
        if (!dispatcher.hasNotificationListener()) {
            dispatcher.removeForwardingNotificationEventListener(this);
            this.nodeMap.remove(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(NodeConnectionEvent event) {
        JPPFManagementInfo info = event.getNodeInformation();
        if (debugEnabled) {
            log.debug("handling new connected node {},", (Object)info);
        }
        if (info == null || info.getPort() < 0 || info.getHost() == null) {
            return;
        }
        String uuid = info.getUuid();
        AsyncNodeContext node = this.driver.getAsyncNodeNioServer().getConnection(uuid);
        if (debugEnabled) {
            log.debug("new connected node {}", (Object)node);
        }
        if (node == null) {
            return;
        }
        this.lock.lock();
        try {
            for (NotificationListenerWrapper wrapper : this.forwardingHelper.allListeners()) {
                if (!this.selectionHelper.isNodeAccepted(node, wrapper.getSelector())) continue;
                this.addNotificationListener(node, wrapper);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void nodeDisconnected(NodeConnectionEvent event) {
        JPPFManagementInfo info = event.getNodeInformation();
        if (debugEnabled) {
            log.debug("handling disconnected node {}", (Object)info);
        }
        String uuid = info.getUuid();
        AsyncNodeContext node = this.driver.getAsyncNodeNioServer().getConnection(uuid);
        if (node == null) {
            return;
        }
        Runnable r = () -> {
            this.lock.lock();
            try {
                for (NotificationListenerWrapper wrapper : this.forwardingHelper.allListeners()) {
                    if (!this.selectionHelper.isNodeAccepted(node, wrapper.getSelector())) continue;
                    this.removeNotificationListener(node, wrapper);
                }
            }
            finally {
                this.lock.unlock();
            }
        };
        ThreadUtils.startThread((Runnable)r, (String)event.toString());
    }

    @Override
    public synchronized void notificationReceived(ForwardingNotificationEvent event) {
        Notification notif = event.getNotification();
        if (debugEnabled) {
            log.debug("received notification from node={}, mbean={}, notification={} (sequence={}, timestamp={}), userData = {}", new Object[]{event.getNodeUuid(), event.getMBeanName(), notif, notif.getSequenceNumber(), notif.getTimeStamp(), notif.getUserData()});
        }
        this.forwarder.sendNotification((Notification)new JPPFNodeForwardingNotification(notif, event.getNodeUuid(), event.getMBeanName()));
    }
}

