/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.forwarding;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jppf.classloader.DelegationModel;
import org.jppf.management.JMXConnectionWrapper;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.management.NodeSelector;
import org.jppf.management.forwarding.AbstractForwardingTask;
import org.jppf.management.forwarding.AbstractNodeForwarding;
import org.jppf.management.forwarding.ForwardCallback;
import org.jppf.management.forwarding.JPPFNodeForwardingMBean;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.InvocationResult;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.collections.CollectionUtils;
import org.slf4j.Logger;

public class JPPFNodeForwarding
extends AbstractNodeForwarding
implements JPPFNodeForwardingMBean {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggingUtils.getLogger(JPPFNodeForwarding.class, (boolean)false);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    public JPPFNodeForwarding(JPPFDriver driver) {
        super(driver);
    }

    public Map<String, Object> forwardInvoke(NodeSelector selector, String name, String methodName, Object[] params, String[] signature) throws Exception {
        Set<BaseNodeContext> channels = this.selectionHelper.getChannels(selector);
        if (debugEnabled) {
            log.debug("invoking {}() on mbean={} for selector={} ({} channels)", new Object[]{methodName, name, selector, channels.size()});
        }
        return this.forward((byte)16, channels, name, methodName, params, signature);
    }

    public Map<String, Object> forwardInvoke(NodeSelector selector, String name, String methodName) throws Exception {
        return this.forwardInvoke(selector, name, methodName, null, null);
    }

    public Map<String, Object> forwardGetAttribute(NodeSelector selector, String name, String attribute) throws Exception {
        Set<BaseNodeContext> channels = this.selectionHelper.getChannels(selector);
        return this.forward((byte)9, channels, name, attribute, new Object[0]);
    }

    public Map<String, Object> forwardSetAttribute(NodeSelector selector, String name, String attribute, Object value) throws Exception {
        Set<BaseNodeContext> channels = this.selectionHelper.getChannels(selector);
        return this.forward((byte)25, channels, name, attribute, value);
    }

    public Map<String, Object> state(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "state");
    }

    public Map<String, Object> updateThreadPoolSize(NodeSelector selector, Integer size) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateThreadPoolSize", CollectionUtils.array((Object[])new Integer[]{size}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Integer"}));
    }

    public Map<String, Object> updateThreadsPriority(NodeSelector selector, Integer newPriority) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateThreadsPriority", CollectionUtils.array((Object[])new Integer[]{newPriority}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Integer"}));
    }

    public Map<String, Object> restart(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "restart");
    }

    public Map<String, Object> restart(NodeSelector selector, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "restart", CollectionUtils.array((Object[])new Boolean[]{interruptIfRunning}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Boolean"}));
    }

    public Map<String, Object> shutdown(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "shutdown");
    }

    public Map<String, Object> shutdown(NodeSelector selector, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "shutdown", CollectionUtils.array((Object[])new Boolean[]{interruptIfRunning}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Boolean"}));
    }

    public Map<String, Object> resetTaskCounter(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "resetTaskCounter");
    }

    public Map<String, Object> setTaskCounter(NodeSelector selector, Integer n) throws Exception {
        return this.forwardSetAttribute(selector, "org.jppf:name=admin,type=node", "TaskCounter", n);
    }

    public Map<String, Object> updateConfiguration(NodeSelector selector, Map<Object, Object> configOverrides, Boolean restart, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateConfiguration", new Object[]{configOverrides, restart, interruptIfRunning}, (String[])CollectionUtils.array((Object[])new String[]{"java.util.Map", "java.lang.Boolean", "java.lang.Boolean"}));
    }

    public Map<String, Object> updateConfiguration(NodeSelector selector, Map<Object, Object> configOverrides, Boolean restart) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateConfiguration", new Object[]{configOverrides, restart}, (String[])CollectionUtils.array((Object[])new String[]{"java.util.Map", "java.lang.Boolean"}));
    }

    public Map<String, Object> cancelJob(NodeSelector selector, String jobUuid, Boolean requeue) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "cancelJob", new Object[]{jobUuid, requeue}, (String[])CollectionUtils.array((Object[])new String[]{"java.lang.String", "java.lang.Boolean"}));
    }

    public Map<String, Object> getDelegationModel(NodeSelector selector) throws Exception {
        return this.forwardGetAttribute(selector, "org.jppf:name=admin,type=node", "DelegationModel");
    }

    public Map<String, Object> setDelegationModel(NodeSelector selector, DelegationModel model) throws Exception {
        return this.forwardSetAttribute(selector, "org.jppf:name=admin,type=node", "DelegationModel", model);
    }

    public Map<String, Object> systemInformation(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "systemInformation");
    }

    public Map<String, Object> healthSnapshot(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "healthSnapshot");
    }

    public Map<String, Object> threadDump(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "threadDump");
    }

    public Map<String, Object> gc(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "gc");
    }

    public Map<String, Object> heapDump(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "heapDump");
    }

    public Map<String, Object> getNbSlaves(NodeSelector selector) throws Exception {
        return this.forwardGetAttribute(selector, "org.jppf:name=provisioning,type=node", "NbSlaves");
    }

    public Map<String, Object> provisionSlaveNodes(NodeSelector selector, int nbNodes) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes}, new String[]{"int"});
    }

    public Map<String, Object> provisionSlaveNodes(NodeSelector selector, int nbNodes, boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes, interruptIfRunning}, new String[]{"int", "boolean"});
    }

    public Map<String, Object> provisionSlaveNodes(NodeSelector selector, int nbNodes, TypedProperties configOverrides) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes, configOverrides}, new String[]{"int", TypedProperties.class.getName()});
    }

    public Map<String, Object> provisionSlaveNodes(NodeSelector selector, int nbNodes, boolean interruptIfRunning, TypedProperties configOverrides) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes, interruptIfRunning, configOverrides}, new String[]{"int", "boolean", TypedProperties.class.getName()});
    }

    Map<String, Object> forward(byte type, Set<BaseNodeContext> nodes, String mbeanName, String memberName, Object ... params) throws Exception {
        try {
            int size = nodes.size();
            if (size <= 0) {
                return Collections.emptyMap();
            }
            ForwardCallbackImpl callback = new ForwardCallbackImpl(size);
            for (BaseNodeContext node : nodes) {
                AbstractForwardingTask<Object> task;
                JMXNodeConnectionWrapper jmx = node.getJmxConnection();
                switch (type) {
                    case 16: {
                        task = new AbstractForwardingTask<Object>(node.getUuid(), (ForwardCallback)callback, (JMXConnectionWrapper)jmx, mbeanName, memberName, params){
                            final /* synthetic */ JMXConnectionWrapper val$jmx;
                            final /* synthetic */ String val$mbeanName;
                            final /* synthetic */ String val$memberName;
                            final /* synthetic */ Object[] val$params;
                            {
                                this.val$jmx = jMXConnectionWrapper;
                                this.val$mbeanName = string;
                                this.val$memberName = string2;
                                this.val$params = objectArray;
                                super(uuid, callback);
                            }

                            @Override
                            Object execute() throws Exception {
                                return this.val$jmx.invoke(this.val$mbeanName, this.val$memberName, (Object[])this.val$params[0], (String[])this.val$params[1]);
                            }
                        };
                        break;
                    }
                    case 9: {
                        task = new AbstractForwardingTask<Object>(node.getUuid(), (ForwardCallback)callback, (JMXConnectionWrapper)jmx, mbeanName, memberName){
                            final /* synthetic */ JMXConnectionWrapper val$jmx;
                            final /* synthetic */ String val$mbeanName;
                            final /* synthetic */ String val$memberName;
                            {
                                this.val$jmx = jMXConnectionWrapper;
                                this.val$mbeanName = string;
                                this.val$memberName = string2;
                                super(uuid, callback);
                            }

                            @Override
                            Object execute() throws Exception {
                                return this.val$jmx.getAttribute(this.val$mbeanName, this.val$memberName);
                            }
                        };
                        break;
                    }
                    case 25: {
                        task = new AbstractForwardingTask<Object>(node.getUuid(), (ForwardCallback)callback, (JMXConnectionWrapper)jmx, mbeanName, memberName, params){
                            final /* synthetic */ JMXConnectionWrapper val$jmx;
                            final /* synthetic */ String val$mbeanName;
                            final /* synthetic */ String val$memberName;
                            final /* synthetic */ Object[] val$params;
                            {
                                this.val$jmx = jMXConnectionWrapper;
                                this.val$mbeanName = string;
                                this.val$memberName = string2;
                                this.val$params = objectArray;
                                super(uuid, callback);
                            }

                            @Override
                            Object execute() throws Exception {
                                this.val$jmx.setAttribute(this.val$mbeanName, this.val$memberName, this.val$params[0]);
                                return null;
                            }
                        };
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("unknown type of operation %d for mbean=%s, memeber=%s, param=%s, node=%s", new Object[]{type, mbeanName, memberName, Arrays.deepToString(params), node}));
                    }
                }
                if (debugEnabled) {
                    log.debug("about to forward with type={}, mbean={}, member={}, params={}, node={}", new Object[]{type, mbeanName, memberName, Arrays.deepToString(params), node});
                }
                this.executor.execute(task);
            }
            return callback.await();
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug("error forwarding with type={}, nb nodes={}, mbeanNaem={}, memberName={}, params={}\n{}", new Object[]{type, nodes.size(), mbeanName, memberName, Arrays.asList(params), ExceptionUtils.getStackTrace((Throwable)e)});
            }
            throw e;
        }
    }

    private static class ForwardCallbackImpl
    implements ForwardCallback<Object> {
        private final Map<String, Object> resultMap;
        private final int expectedCount;
        private int count;

        ForwardCallbackImpl(int expectedCount) {
            this.resultMap = new HashMap<String, Object>(expectedCount);
            this.expectedCount = expectedCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gotResult(String uuid, InvocationResult<Object> result) {
            ForwardCallbackImpl forwardCallbackImpl = this;
            synchronized (forwardCallbackImpl) {
                this.resultMap.put(uuid, result.isException() ? result.exception() : result.result());
                if (++this.count == this.expectedCount) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> await() throws Exception {
            ForwardCallbackImpl forwardCallbackImpl = this;
            synchronized (forwardCallbackImpl) {
                while (this.count < this.expectedCount) {
                    this.wait();
                }
            }
            return this.resultMap;
        }
    }
}

