/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.forwarding;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jppf.classloader.DelegationModel;
import org.jppf.management.JMXConnectionWrapper;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.management.JPPFNodeState;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.NodeSelector;
import org.jppf.management.diagnostics.HealthSnapshot;
import org.jppf.management.diagnostics.ThreadDump;
import org.jppf.management.forwarding.AbstractForwardingTask;
import org.jppf.management.forwarding.AbstractNodeForwarding;
import org.jppf.management.forwarding.ForwardCallback;
import org.jppf.management.forwarding.NodeForwardingMBean;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.InvocationResult;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ResultsMap;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.collections.CollectionUtils;
import org.slf4j.Logger;

public class NodeForwarding
extends AbstractNodeForwarding
implements NodeForwardingMBean {
    private static final Logger log = LoggingUtils.getLogger(NodeForwarding.class, (boolean)false);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    public NodeForwarding(JPPFDriver driver) {
        super(driver);
    }

    public <E> ResultsMap<String, E> forwardInvoke(NodeSelector selector, String name, String methodName, Object[] params, String[] signature) throws Exception {
        Set<BaseNodeContext> channels = this.selectionHelper.getChannels(selector);
        if (debugEnabled) {
            log.debug("invoking {}() on mbean={} for selector={} ({} channels)", new Object[]{methodName, name, selector, channels.size()});
        }
        return this.forward((byte)16, channels, name, methodName, params, signature);
    }

    public <E> ResultsMap<String, E> forwardInvoke(NodeSelector selector, String name, String methodName) throws Exception {
        return this.forwardInvoke(selector, name, methodName, null, null);
    }

    public <E> ResultsMap<String, E> forwardGetAttribute(NodeSelector selector, String name, String attribute) throws Exception {
        return this.forward((byte)9, this.selectionHelper.getChannels(selector), name, attribute, new Object[0]);
    }

    public ResultsMap<String, Void> forwardSetAttribute(NodeSelector selector, String name, String attribute, Object value) throws Exception {
        return this.forward((byte)25, this.selectionHelper.getChannels(selector), name, attribute, value);
    }

    public ResultsMap<String, JPPFNodeState> state(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "state");
    }

    public ResultsMap<String, Void> updateThreadPoolSize(NodeSelector selector, Integer size) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateThreadPoolSize", CollectionUtils.array((Object[])new Integer[]{size}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Integer"}));
    }

    public ResultsMap<String, Void> updateThreadsPriority(NodeSelector selector, Integer newPriority) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateThreadsPriority", CollectionUtils.array((Object[])new Integer[]{newPriority}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Integer"}));
    }

    public ResultsMap<String, Void> restart(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "restart");
    }

    public ResultsMap<String, Void> restart(NodeSelector selector, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "restart", CollectionUtils.array((Object[])new Boolean[]{interruptIfRunning}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Boolean"}));
    }

    public ResultsMap<String, Void> shutdown(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "shutdown");
    }

    public ResultsMap<String, Void> shutdown(NodeSelector selector, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "shutdown", CollectionUtils.array((Object[])new Boolean[]{interruptIfRunning}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Boolean"}));
    }

    public ResultsMap<String, Void> reconnect(NodeSelector selector, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "reconnect", CollectionUtils.array((Object[])new Boolean[]{interruptIfRunning}), (String[])CollectionUtils.array((Object[])new String[]{"java.lang.Boolean"}));
    }

    public ResultsMap<String, Void> resetTaskCounter(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "resetTaskCounter");
    }

    public ResultsMap<String, Void> setTaskCounter(NodeSelector selector, Integer n) throws Exception {
        return this.forward((byte)25, this.selectionHelper.getChannels(selector), "org.jppf:name=admin,type=node", "TaskCounter", n);
    }

    public ResultsMap<String, Void> updateConfiguration(NodeSelector selector, Map<Object, Object> configOverrides, Boolean restart, Boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateConfiguration", new Object[]{configOverrides, restart, interruptIfRunning}, (String[])CollectionUtils.array((Object[])new String[]{"java.util.Map", "java.lang.Boolean", "java.lang.Boolean"}));
    }

    public ResultsMap<String, Void> updateConfiguration(NodeSelector selector, Map<Object, Object> configOverrides, Boolean restart) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "updateConfiguration", new Object[]{configOverrides, restart}, (String[])CollectionUtils.array((Object[])new String[]{"java.util.Map", "java.lang.Boolean"}));
    }

    public ResultsMap<String, Void> cancelJob(NodeSelector selector, String jobUuid, Boolean requeue) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "cancelJob", new Object[]{jobUuid, requeue}, (String[])CollectionUtils.array((Object[])new String[]{"java.lang.String", "java.lang.Boolean"}));
    }

    public ResultsMap<String, DelegationModel> getDelegationModel(NodeSelector selector) throws Exception {
        return this.forward((byte)9, this.selectionHelper.getChannels(selector), "org.jppf:name=admin,type=node", "DelegationModel", new Object[0]);
    }

    public ResultsMap<String, Void> setDelegationModel(NodeSelector selector, DelegationModel model) throws Exception {
        return this.forward((byte)25, this.selectionHelper.getChannels(selector), "org.jppf:name=admin,type=node", "DelegationModel", model);
    }

    public ResultsMap<String, JPPFSystemInformation> systemInformation(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=admin,type=node", "systemInformation");
    }

    public ResultsMap<String, HealthSnapshot> healthSnapshot(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "healthSnapshot");
    }

    public ResultsMap<String, Void> gc(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "gc");
    }

    public ResultsMap<String, String> heapDump(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "heapDump");
    }

    public ResultsMap<String, ThreadDump> threadDump(NodeSelector selector) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=diagnostics,type=node", "threadDump");
    }

    public ResultsMap<String, Integer> getNbSlaves(NodeSelector selector) throws Exception {
        return this.forward((byte)9, this.selectionHelper.getChannels(selector), "org.jppf:name=provisioning,type=node", "NbSlaves", new Object[0]);
    }

    public ResultsMap<String, Void> provisionSlaveNodes(NodeSelector selector, int nbNodes) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes}, new String[]{"int"});
    }

    public ResultsMap<String, Void> provisionSlaveNodes(NodeSelector selector, int nbNodes, boolean interruptIfRunning) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes, interruptIfRunning}, new String[]{"int", "boolean"});
    }

    public ResultsMap<String, Void> provisionSlaveNodes(NodeSelector selector, int nbNodes, TypedProperties configOverrides) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes, configOverrides}, new String[]{"int", TypedProperties.class.getName()});
    }

    public ResultsMap<String, Void> provisionSlaveNodes(NodeSelector selector, int nbNodes, boolean interruptIfRunning, TypedProperties configOverrides) throws Exception {
        return this.forwardInvoke(selector, "org.jppf:name=provisioning,type=node", "provisionSlaveNodes", new Object[]{nbNodes, interruptIfRunning, configOverrides}, new String[]{"int", "boolean", TypedProperties.class.getName()});
    }

    <E> ResultsMap<String, E> forward(byte type, Set<BaseNodeContext> nodes, String mbeanName, String memberName, Object ... params) throws Exception {
        try {
            int size = nodes.size();
            if (size <= 0) {
                return new ResultsMap();
            }
            ForwardCallbackImpl callback = new ForwardCallbackImpl(size);
            for (BaseNodeContext node : nodes) {
                AbstractForwardingTask task;
                JMXNodeConnectionWrapper jmx = node.getJmxConnection();
                switch (type) {
                    case 16: {
                        task = new AbstractForwardingTask<E>(node.getUuid(), callback, (JMXConnectionWrapper)jmx, mbeanName, memberName, params){
                            final /* synthetic */ JMXConnectionWrapper val$jmx;
                            final /* synthetic */ String val$mbeanName;
                            final /* synthetic */ String val$memberName;
                            final /* synthetic */ Object[] val$params;
                            {
                                this.val$jmx = jMXConnectionWrapper;
                                this.val$mbeanName = string;
                                this.val$memberName = string2;
                                this.val$params = objectArray;
                                super(uuid, callback);
                            }

                            @Override
                            E execute() throws Exception {
                                return this.val$jmx.invoke(this.val$mbeanName, this.val$memberName, (Object[])this.val$params[0], (String[])this.val$params[1]);
                            }
                        };
                        break;
                    }
                    case 9: {
                        task = new AbstractForwardingTask<E>(node.getUuid(), callback, (JMXConnectionWrapper)jmx, mbeanName, memberName){
                            final /* synthetic */ JMXConnectionWrapper val$jmx;
                            final /* synthetic */ String val$mbeanName;
                            final /* synthetic */ String val$memberName;
                            {
                                this.val$jmx = jMXConnectionWrapper;
                                this.val$mbeanName = string;
                                this.val$memberName = string2;
                                super(uuid, callback);
                            }

                            @Override
                            E execute() throws Exception {
                                return this.val$jmx.getAttribute(this.val$mbeanName, this.val$memberName);
                            }
                        };
                        break;
                    }
                    case 25: {
                        task = new AbstractForwardingTask<E>(node.getUuid(), callback, (JMXConnectionWrapper)jmx, mbeanName, memberName, params){
                            final /* synthetic */ JMXConnectionWrapper val$jmx;
                            final /* synthetic */ String val$mbeanName;
                            final /* synthetic */ String val$memberName;
                            final /* synthetic */ Object[] val$params;
                            {
                                this.val$jmx = jMXConnectionWrapper;
                                this.val$mbeanName = string;
                                this.val$memberName = string2;
                                this.val$params = objectArray;
                                super(uuid, callback);
                            }

                            @Override
                            E execute() throws Exception {
                                this.val$jmx.setAttribute(this.val$mbeanName, this.val$memberName, this.val$params[0]);
                                return null;
                            }
                        };
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("unknown type of operation %d for mbean=%s, memeber=%s, param=%s, node=%s", new Object[]{type, mbeanName, memberName, Arrays.deepToString(params), node}));
                    }
                }
                if (debugEnabled) {
                    log.debug("about to forward with type={}, mbean={}, member={}, params={}, node={}", new Object[]{type, mbeanName, memberName, Arrays.deepToString(params), node});
                }
                this.executor.execute(task);
            }
            return callback.await();
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug("error forwarding with type={}, nb nodes={}, mbeanNaem={}, memberName={}, params={}\n{}", new Object[]{type, nodes.size(), mbeanName, memberName, Arrays.asList(params), ExceptionUtils.getStackTrace((Throwable)e)});
            }
            throw e;
        }
    }

    private static class ForwardCallbackImpl<E>
    implements ForwardCallback<E> {
        private final ResultsMap<String, E> resultMap = new ResultsMap();
        private final int expectedCount;
        private int count;

        ForwardCallbackImpl(int expectedCount) {
            this.expectedCount = expectedCount;
        }

        @Override
        public synchronized void gotResult(String uuid, InvocationResult<E> result) {
            this.resultMap.put((Object)uuid, result);
            if (++this.count == this.expectedCount) {
                this.notify();
            }
        }

        public synchronized ResultsMap<String, E> await() throws Exception {
            while (this.count < this.expectedCount) {
                this.wait();
            }
            return this.resultMap;
        }
    }
}

