/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.JPPFInitializer;
import org.jppf.logging.jmx.JmxMessageNotifier;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.PeerDriver;
import org.jppf.nio.NioServer;
import org.jppf.nio.acceptor.AcceptorNioServer;
import org.jppf.node.initialization.OutputRedirectHook;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.server.DriverInitializer;
import org.jppf.server.StatsSystemInformationUpdater;
import org.jppf.server.job.JPPFJobManager;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.jppf.server.nio.classloader.node.AsyncNodeClassNioServer;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.heartbeat.HeartbeatNioServer;
import org.jppf.server.nio.nodeserver.async.AsyncNodeNioServer;
import org.jppf.server.node.JPPFNode;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.jppf.utils.JPPFDefaultUncaughtExceptionHandler;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ObjectSerializerImpl;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.VersionUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.stats.JPPFStatistics;
import org.jppf.utils.stats.JPPFStatisticsHelper;
import org.jppf.utils.stats.JPPFStatisticsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJPPFDriver {
    private static final Logger log;
    private static boolean debugEnabled;
    private final ObjectSerializer serializer = new ObjectSerializerImpl();
    JPPFNode localNode;
    JPPFPriorityQueue taskQueue;
    AsyncClientNioServer asyncClientNioServer;
    AsyncNodeNioServer asyncNodeNioServer;
    AsyncClientClassNioServer asyncClientClassServer;
    AsyncNodeClassNioServer asyncNodeClassServer;
    AcceptorNioServer acceptorServer;
    HeartbeatNioServer nodeHeartbeatServer;
    HeartbeatNioServer clientHeartbeatServer;
    final AtomicBoolean shutdownSchduled = new AtomicBoolean(false);
    final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    final JPPFStatistics statistics;
    JPPFJobManager jobManager;
    final String uuid;
    DriverInitializer initializer;
    final TypedProperties configuration;
    JPPFSystemInformation systemInformation;
    PeerDriver peerDriver;
    final boolean jppfDebugEnabled;

    public AbstractJPPFDriver(TypedProperties configuration) {
        this.configuration = configuration;
        String s = configuration.getString("jppf.driver.uuid", null);
        this.uuid = s == null ? JPPFUuid.normalUUID() : s;
        new JmxMessageNotifier();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JPPFDefaultUncaughtExceptionHandler());
        new OutputRedirectHook().initializing(configuration);
        VersionUtils.logVersionInformation((String)"driver", (String)this.uuid);
        SystemUtils.printPidAndUuid((String)"driver", (String)this.uuid);
        this.statistics = JPPFStatisticsHelper.createServerStatistics();
        this.systemInformation = new JPPFSystemInformation(configuration, this.uuid, false, true, this.statistics);
        this.statistics.addListener((JPPFStatisticsListener)new StatsSystemInformationUpdater(this.systemInformation));
        this.jppfDebugEnabled = (Boolean)configuration.get(JPPFProperties.DEBUG_ENABLED);
    }

    public JPPFPriorityQueue getQueue() {
        return this.taskQueue;
    }

    public AsyncClientNioServer getAsyncClientNioServer() {
        return this.asyncClientNioServer;
    }

    public AsyncClientClassNioServer getAsyncClientClassServer() {
        return this.asyncClientClassServer;
    }

    public AsyncNodeClassNioServer getAsyncNodeClassServer() {
        return this.asyncNodeClassServer;
    }

    public AsyncNodeNioServer getAsyncNodeNioServer() {
        return this.asyncNodeNioServer;
    }

    public AcceptorNioServer getAcceptorServer() {
        return this.acceptorServer;
    }

    public JPPFJobManager getJobManager() {
        return this.jobManager;
    }

    public DriverInitializer getInitializer() {
        return this.initializer;
    }

    static <T extends NioServer> T startServer(T nioServer) {
        if (nioServer == null) {
            throw new IllegalArgumentException("nioServer is null");
        }
        if (debugEnabled) {
            log.debug("starting nio server {}", nioServer);
        }
        nioServer.start();
        AbstractJPPFDriver.printInitializedMessage(nioServer.getPorts(), nioServer.getSSLPorts(), nioServer.getName());
        return nioServer;
    }

    private static void printInitializedMessage(int[] ports, int[] sslPorts, String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name);
            sb.append(" initialized");
        }
        if (ports != null && ports.length > 0) {
            sb.append("\n-  accepting plain connections on port");
            if (ports.length > 1) {
                sb.append('s');
            }
            for (int n : ports) {
                sb.append(' ').append(n);
            }
        }
        if (sslPorts != null && sslPorts.length > 0) {
            sb.append("\n- accepting secure connections on port");
            if (sslPorts.length > 1) {
                sb.append('s');
            }
            for (int n : sslPorts) {
                sb.append(' ').append(n);
            }
        }
        System.out.println(sb.toString());
        if (debugEnabled) {
            log.debug(sb.toString());
        }
    }

    static boolean isManagementEnabled(TypedProperties config) {
        return (Boolean)config.get(JPPFProperties.MANAGEMENT_ENABLED);
    }

    static int[] extractValidPorts(int[] ports) {
        if (ports == null || ports.length == 0) {
            return ports;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int port : ports) {
            if (port < 0) continue;
            list.add(port);
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    public ObjectSerializer getSerializer() {
        return this.serializer;
    }

    public PeerDriver getPeerDriver() {
        return this.peerDriver;
    }

    public void setPeerDriver(PeerDriver peerDriver) {
        this.peerDriver = peerDriver;
    }

    public boolean isJppfDebugEnabled() {
        return this.jppfDebugEnabled;
    }

    static {
        JPPFInitializer.init();
        log = LoggerFactory.getLogger(AbstractJPPFDriver.class);
        debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    }
}

