/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFBroadcaster;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.discovery.DriverConnectionInfo;
import org.jppf.discovery.DriverDiscoveryHandler;
import org.jppf.discovery.DriverDiscoveryListener;
import org.jppf.discovery.PeerDriverDiscovery;
import org.jppf.load.balancer.ChannelAwareness;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JMXServer;
import org.jppf.management.JMXServerFactory;
import org.jppf.management.NodeSelector;
import org.jppf.management.ObjectNameCache;
import org.jppf.management.forwarding.ForwardingNotificationListener;
import org.jppf.management.spi.JPPFDriverMBeanProvider;
import org.jppf.management.spi.JPPFMBeanProviderManager;
import org.jppf.persistence.JPPFDatasourceFactory;
import org.jppf.server.JPPFDriver;
import org.jppf.server.PeerDriverDiscoveryListener;
import org.jppf.server.debug.ServerDebug;
import org.jppf.server.debug.ServerDebugMBean;
import org.jppf.server.event.NodeConnectionEventHandler;
import org.jppf.server.nio.classloader.ClassCache;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.server.peer.PeerConnectionPoolHandler;
import org.jppf.server.peer.PeerDiscoveryThread;
import org.jppf.startup.JPPFDriverStartupSPI;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ReflectionUtils;
import org.jppf.utils.RegexUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.DeadlockDetector;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.jppf.utils.hooks.Hook;
import org.jppf.utils.hooks.HookFactory;
import org.jppf.utils.hooks.HookInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverInitializer {
    static Logger log = LoggerFactory.getLogger(DriverInitializer.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    protected static final String VALUE_JPPF_DISCOVERY = "jppf_discovery";
    private JPPFDriver driver = null;
    private PeerDiscoveryThread peerDiscoveryThread = null;
    private JPPFBroadcaster broadcaster = null;
    private TypedProperties config = null;
    private JPPFConnectionInformation connectionInfo = null;
    private JMXServer jmxServer = null;
    private JMXServer sslJmxServer = null;
    private ServerDebug serverDebug = null;
    private final NodeConnectionEventHandler nodeConnectionEventHandler = new NodeConnectionEventHandler();
    private final ClassCache classCache = new ClassCache();
    final DriverDiscoveryHandler<DriverConnectionInfo> discoveryHandler = new DriverDiscoveryHandler(PeerDriverDiscovery.class);
    private PeerDriverDiscoveryListener discoveryListener;
    private final PeerConnectionPoolHandler peerConnectionPoolHandler;

    public DriverInitializer(JPPFDriver driver, TypedProperties config) {
        this.driver = driver;
        this.config = config;
        this.peerConnectionPoolHandler = new PeerConnectionPoolHandler(driver, config);
    }

    void handleDebugActions() {
        if (((Boolean)this.driver.getConfiguration().get(JPPFProperties.DEBUG_ENABLED)).booleanValue()) {
            if (this.driver.getConfiguration().getBoolean("jppf.deadlock.detector.enabled", true)) {
                if (debugEnabled) {
                    log.debug("registering deadlock detector");
                }
                DeadlockDetector.setup((String)"driver");
            }
            if (debugEnabled) {
                log.debug("registering debug mbean");
            }
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                this.serverDebug = new ServerDebug(this.driver);
                StandardMBean mbean = new StandardMBean(this.serverDebug, ServerDebugMBean.class);
                server.registerMBean(mbean, ObjectNameCache.getObjectName((String)"org.jppf:name=debug,type=driver"));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    void registerProviderMBeans() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        new JPPFMBeanProviderManager(JPPFDriverMBeanProvider.class, null, (Object)server, new Object[]{this.driver});
        this.registerNodeConfigListener();
    }

    public JPPFConnectionInformation getConnectionInformation() {
        if (this.connectionInfo == null) {
            this.connectionInfo = new JPPFConnectionInformation();
            this.connectionInfo.uuid = this.driver.getUuid();
            String s = this.config.getString("jppf.server.port", "11111");
            this.connectionInfo.serverPorts = DriverInitializer.parsePorts(s, 11111);
            s = this.config.getString("jppf.ssl.server.port", null);
            this.connectionInfo.sslServerPorts = s != null ? DriverInitializer.parsePorts(s, -1) : null;
            try {
                this.connectionInfo.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.connectionInfo.host = "localhost";
            }
            this.connectionInfo.recoveryEnabled = (Boolean)this.config.get(JPPFProperties.RECOVERY_ENABLED);
        }
        return this.connectionInfo;
    }

    public void initBroadcaster() {
        if (((Boolean)this.config.get(JPPFProperties.DISCOVERY_ENABLED)).booleanValue()) {
            if (debugEnabled) {
                log.debug("initializing broadcaster");
            }
            this.broadcaster = new JPPFBroadcaster(this.getConnectionInformation());
            ThreadUtils.startThread((Runnable)this.broadcaster, (String)"JPPF Broadcaster");
        }
    }

    public void stopBroadcaster() {
        if (this.broadcaster != null) {
            if (debugEnabled) {
                log.debug("stopping broadcaster");
            }
            this.broadcaster.close();
            this.broadcaster = null;
        }
    }

    public boolean isBroadcasting() {
        return this.broadcaster != null && !this.broadcaster.isStopped();
    }

    void initPeers() {
        boolean initPeers;
        TypedProperties props = this.driver.getConfiguration();
        boolean ssl = (Boolean)props.get(JPPFProperties.PEER_SSL_ENABLED);
        boolean enabled = (Boolean)props.get(JPPFProperties.PEER_DISCOVERY_ENABLED);
        if (debugEnabled) {
            log.debug("{} = {}", (Object)JPPFProperties.PEER_DISCOVERY_ENABLED.getName(), (Object)enabled);
        }
        if (enabled) {
            if (debugEnabled) {
                log.debug("starting peers discovery");
            }
            this.peerDiscoveryThread = new PeerDiscoveryThread(this.driver.getConfiguration(), new IPFilter(props, true), this.getConnectionInformation(), (name, info) -> {
                this.peerDiscoveryThread.addConnectionInformation(info);
                this.getPeerConnectionPoolHandler().newPool(name, (Integer)this.config.get(JPPFProperties.PEER_POOL_SIZE), info, ssl, false);
            });
            initPeers = false;
        } else {
            this.peerDiscoveryThread = null;
            initPeers = true;
        }
        String discoveryNames = (String)props.get(JPPFProperties.PEERS);
        if (debugEnabled) {
            log.debug("discoveryNames = {}", (Object)discoveryNames);
        }
        if (discoveryNames != null && !discoveryNames.trim().isEmpty()) {
            String[] names;
            if (debugEnabled) {
                log.debug("found peers in the configuration");
            }
            for (String name2 : names = RegexUtils.SPACES_PATTERN.split(discoveryNames)) {
                initPeers |= VALUE_JPPF_DISCOVERY.equals(name2);
            }
            if (initPeers) {
                for (String name2 : names) {
                    if (VALUE_JPPF_DISCOVERY.equals(name2)) continue;
                    JPPFConnectionInformation info2 = new JPPFConnectionInformation();
                    info2.host = (String)props.get(JPPFProperties.PARAM_PEER_SERVER_HOST, new String[]{name2});
                    int[] ports = new int[]{(Integer)props.get(JPPFProperties.PARAM_PEER_SERVER_PORT, new String[]{name2})};
                    boolean peerSSL = ssl;
                    if (props.containsKey((Object)JPPFProperties.PARAM_PEER_SSL_ENABLED.resolveName(new String[]{name2}))) {
                        peerSSL = (Boolean)props.get(JPPFProperties.PARAM_PEER_SSL_ENABLED, new String[]{name2});
                    }
                    if (peerSSL) {
                        info2.sslServerPorts = ports;
                    } else {
                        info2.serverPorts = ports;
                    }
                    int size = (Integer)props.get(JPPFProperties.PARAM_PEER_POOL_SIZE, new String[]{name2});
                    info2.recoveryEnabled = (Boolean)props.get(JPPFProperties.PARAM_PEER_RECOVERY_ENABLED, new String[]{name2});
                    if (this.peerDiscoveryThread != null) {
                        this.peerDiscoveryThread.addConnectionInformation(info2);
                    }
                    if (debugEnabled) {
                        log.debug("read peer configuration: name={}, size={}, secure={}, info={}", new Object[]{name2, size, peerSSL, info2});
                    }
                    this.getPeerConnectionPoolHandler().newPool(name2, size, info2, peerSSL, false);
                }
            }
        }
        if (this.peerDiscoveryThread != null) {
            ThreadUtils.startThread((Runnable)this.peerDiscoveryThread, (String)"PeerDiscovery");
        }
        this.discoveryListener = new PeerDriverDiscoveryListener(this.driver);
        this.discoveryHandler.register((DriverDiscoveryListener)this.discoveryListener.open()).start();
    }

    public PeerDiscoveryThread getPeerDiscoveryThread() {
        return this.peerDiscoveryThread;
    }

    void stopPeerDiscoveryThread() {
        if (this.peerDiscoveryThread != null) {
            this.peerDiscoveryThread.setStopped(true);
            this.peerDiscoveryThread = null;
        }
    }

    public synchronized JMXServer getJmxServer(boolean ssl) {
        return ssl ? this.sslJmxServer : this.jmxServer;
    }

    void initJmxServer() {
        this.jmxServer = this.createJMXServer(false);
        this.sslJmxServer = this.createJMXServer(true);
    }

    private JMXServer createJMXServer(boolean ssl) {
        JMXServer server = null;
        String tmp = ssl ? "secure " : "";
        try {
            if (((Boolean)this.config.get(JPPFProperties.MANAGEMENT_ENABLED)).booleanValue()) {
                if (debugEnabled) {
                    log.debug("initializing {}management", (Object)tmp);
                }
                String protocol = (String)this.driver.getConfiguration().get(JPPFProperties.JMX_REMOTE_PROTOCOL);
                JPPFProperty jmxProp = null;
                jmxProp = "jppf".equals(protocol) ? (ssl ? JPPFProperties.SERVER_SSL_PORT : JPPFProperties.SERVER_PORT) : (ssl ? JPPFProperties.MANAGEMENT_SSL_PORT : JPPFProperties.MANAGEMENT_PORT);
                int port = (Integer)this.driver.getConfiguration().get(jmxProp);
                if (port < 0) {
                    return null;
                }
                server = JMXServerFactory.createServer((TypedProperties)this.driver.configuration, (String)this.driver.getUuid(), (boolean)ssl, (JPPFProperty)jmxProp);
                server.start(this.getClass().getClassLoader());
                String msg = String.format("%smanagement initialized and listening on port %s", tmp, server.getManagementPort());
                System.out.println(msg);
                if (debugEnabled) {
                    log.debug(msg);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.config.set(JPPFProperties.MANAGEMENT_ENABLED, (Object)false);
            String s = e.getMessage();
            s = s == null ? "<none>" : s.replace("\t", "  ").replace("\n", " - ");
            System.out.println(tmp + "management failed to initialize, with error message: '" + s + '\'');
            System.out.println(tmp + "management features are disabled. Please consult the driver's log file for more information");
        }
        return server;
    }

    void stopJmxServer() {
        try {
            if (debugEnabled) {
                log.debug("stopping JMX server");
            }
            if (this.jmxServer != null) {
                this.jmxServer.stop();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ServerDebug getServerDebug() {
        return this.serverDebug;
    }

    public NodeConnectionEventHandler getNodeConnectionEventHandler() {
        return this.nodeConnectionEventHandler;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    void registerNodeConfigListener() {
        if (debugEnabled) {
            log.debug("registering NodeConfigListener");
        }
        try (JMXDriverConnectionWrapper jmx = new JMXDriverConnectionWrapper();){
            jmx.connect();
            ForwardingNotificationListener listener = (notification, handback) -> {
                AsyncNodeContext node;
                Notification notif = notification.getNotification();
                String nodeUuid = (String)notif.getSource();
                TypedProperties nodeConfig = (TypedProperties)notif.getUserData();
                if (debugEnabled) {
                    log.debug("received notification for node {}, nb threads={}", (Object)nodeUuid, nodeConfig.get(JPPFProperties.PROCESSING_THREADS));
                }
                if ((node = this.driver.getAsyncNodeNioServer().getConnection(nodeUuid)) == null) {
                    return;
                }
                Object object = node.getMonitor();
                synchronized (object) {
                    TypedProperties oldConfig = node.getSystemInformation().getJppf();
                    oldConfig.clear();
                    oldConfig.putAll((Map)nodeConfig);
                    if (node.getBundler() instanceof ChannelAwareness) {
                        ((ChannelAwareness)node.getBundler()).setChannelConfiguration(node.getSystemInformation());
                    }
                }
            };
            jmx.registerForwardingNotificationListener(NodeSelector.ALL_NODES, "org.jppf:name=config.notifier,type=node", (NotificationListener)listener, null, null);
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private static int[] parsePorts(String s, int def) {
        String[] strPorts = RegexUtils.SPACES_PATTERN.split(s);
        ArrayList<Integer> portsList = new ArrayList<Integer>(strPorts.length);
        for (int i = 0; i < strPorts.length; ++i) {
            try {
                int n = Integer.valueOf(strPorts[i].trim());
                portsList.add(n);
                continue;
            }
            catch (NumberFormatException e) {
                if (!debugEnabled) continue;
                log.debug("invalid port number value '" + strPorts[i] + "'");
            }
        }
        if (portsList.isEmpty() && def > 0) {
            portsList.add(def);
        }
        int[] ports = new int[portsList.size()];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (Integer)portsList.get(i);
        }
        return ports;
    }

    public Set<DriverConnectionInfo> getDiscoveredPeers() {
        return this.discoveryListener.getDiscoveredPools();
    }

    void initDatasources() {
        JPPFDatasourceFactory factory = JPPFDatasourceFactory.getInstance();
        factory.configure(this.driver.getConfiguration(), JPPFDatasourceFactory.Scope.LOCAL);
    }

    public PeerConnectionPoolHandler getPeerConnectionPoolHandler() {
        return this.peerConnectionPoolHandler;
    }

    void initStartups() {
        Hook hook = HookFactory.registerSPIMultipleHook(JPPFDriverStartupSPI.class, null, null);
        for (HookInstance hookInstance : hook.getInstances()) {
            JPPFDriverStartupSPI instance = (JPPFDriverStartupSPI)hookInstance.getInstance();
            Method m = ReflectionUtils.getSetter(instance.getClass(), (String)"setDriver");
            if (m != null && JPPFDriver.class.isAssignableFrom(m.getParameterTypes()[0])) {
                try {
                    m.invoke((Object)instance, this.driver);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    log.error("error seting JPPFDriver on startup of type {}", (Object)instance.getClass().getName(), (Object)e);
                }
            }
            hookInstance.invoke("run", new Object[0]);
        }
    }
}

