/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jppf.JPPFException;
import org.jppf.classloader.AbstractClassLoaderConnection;
import org.jppf.classloader.AsyncLocalClassLoaderConnection;
import org.jppf.classloader.AsyncLocalNodeClassloaderContext;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.discovery.DriverDiscovery;
import org.jppf.discovery.PeerDriverDiscovery;
import org.jppf.job.JobTasksListenerManager;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.nio.NioHelper;
import org.jppf.nio.NioServer;
import org.jppf.nio.acceptor.AcceptorNioServer;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.process.LauncherListener;
import org.jppf.server.AbstractJPPFDriver;
import org.jppf.server.DriverInitializer;
import org.jppf.server.ShutdownRestartTask;
import org.jppf.server.job.JPPFJobManager;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.classloader.node.AsyncNodeClassNioServer;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.heartbeat.HeartbeatNioServer;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.server.nio.nodeserver.async.AsyncNodeNioServer;
import org.jppf.server.node.local.AsyncLocalNodeConnection;
import org.jppf.server.node.local.JPPFLocalNode;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFDriver
extends AbstractJPPFDriver {
    private static final Logger log = LoggerFactory.getLogger(JPPFDriver.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    boolean startedfromMain = false;

    public JPPFDriver(TypedProperties configuration) {
        super(configuration);
        this.initializer = new DriverInitializer(this, configuration);
        this.initializer.initDatasources();
        this.jobManager = new JPPFJobManager(this);
        this.taskQueue = new JPPFPriorityQueue(this, this.jobManager);
        if (debugEnabled) {
            log.debug("JPPF Driver system properties: {}", (Object)SystemUtils.printSystemProperties());
            log.debug("JPPF Driver configuration:\n{}", (Object)configuration.asString());
        }
    }

    public JPPFDriver start() throws Exception {
        boolean useSSL;
        if (debugEnabled) {
            log.debug("starting JPPF driver");
        }
        JPPFConnectionInformation info = this.initializer.getConnectionInformation();
        this.initializer.handleDebugActions();
        int[] sslPorts = JPPFDriver.extractValidPorts(info.sslServerPorts);
        boolean bl = useSSL = sslPorts != null && sslPorts.length > 0;
        if (debugEnabled) {
            log.debug("starting nio servers");
        }
        if (((Boolean)this.configuration.get(JPPFProperties.RECOVERY_ENABLED)).booleanValue()) {
            this.nodeHeartbeatServer = this.initHeartbeatServer(65527, useSSL);
            this.clientHeartbeatServer = this.initHeartbeatServer(65526, useSSL);
        }
        this.asyncClientClassServer = JPPFDriver.startServer(new AsyncClientClassNioServer(this, 65531, useSSL));
        NioHelper.putServer((int)65531, (NioServer)this.asyncClientClassServer);
        this.asyncNodeClassServer = JPPFDriver.startServer(new AsyncNodeClassNioServer(this, 65533, useSSL));
        NioHelper.putServer((int)65533, (NioServer)this.asyncNodeClassServer);
        this.asyncClientNioServer = JPPFDriver.startServer(new AsyncClientNioServer(this, 65530, useSSL));
        NioHelper.putServer((int)65530, (NioServer)this.asyncClientNioServer);
        this.asyncNodeNioServer = JPPFDriver.startServer(new AsyncNodeNioServer(this, 65532, useSSL));
        NioHelper.putServer((int)65532, (NioServer)this.asyncNodeNioServer);
        this.acceptorServer = new AcceptorNioServer(JPPFDriver.extractValidPorts(info.serverPorts), sslPorts, this.statistics, this.configuration);
        NioHelper.putServer((int)65529, (NioServer)this.acceptorServer);
        this.jobManager.loadTaskReturnListeners();
        if (JPPFDriver.isManagementEnabled(this.configuration)) {
            this.initializer.registerProviderMBeans();
        }
        this.initializer.initJmxServer();
        this.initializer.initStartups();
        this.initializer.getNodeConnectionEventHandler().loadListeners();
        JPPFDriver.startServer(this.acceptorServer);
        if (((Boolean)this.configuration.get(JPPFProperties.LOCAL_NODE_ENABLED)).booleanValue()) {
            this.initLocalNode();
        }
        this.initializer.initBroadcaster();
        this.initializer.initPeers();
        this.taskQueue.getPersistenceHandler().loadPersistedJobs();
        if (debugEnabled) {
            log.debug("JPPF Driver initialization complete");
        }
        System.out.println("JPPF Driver initialization complete");
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public JPPFDistributedJob getJob(String uuid) {
        return this.getQueue().getJob(uuid);
    }

    public void initiateShutdownRestart(long shutdownDelay, boolean restart, long restartDelay) {
        if (this.shutdownSchduled.compareAndSet(false, true)) {
            log.info("Scheduling server shutdown in " + shutdownDelay + " ms");
            Timer timer = new Timer();
            ShutdownRestartTask task = new ShutdownRestartTask(restart, restartDelay, this);
            timer.schedule((TimerTask)task, shutdownDelay <= 0L ? 0L : shutdownDelay);
        } else {
            log.info("shutdown/restart request ignored because a previous request is already scheduled");
        }
    }

    public JobTasksListenerManager getJobTasksListenerManager() {
        return this.jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        block11: {
            try {
                Object lock;
                if (debugEnabled) {
                    log.debug("starting the JPPF driver");
                }
                if (args == null || args.length <= 0) {
                    throw new JPPFException("The driver should be run with an argument representing a valid TCP port or 'noLauncher'");
                }
                JPPFDriver driver = new JPPFDriver(JPPFConfiguration.getProperties());
                driver.startedfromMain = true;
                if (!"noLauncher".equals(args[0])) {
                    new LauncherListener(Integer.parseInt(args[0])).start();
                }
                driver.start();
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        while (true) {
                            lock.wait();
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                if (!((Boolean)JPPFConfiguration.get((JPPFProperty)JPPFProperties.SERVER_EXIT_ON_SHUTDOWN)).booleanValue()) break block11;
                System.exit(1);
            }
        }
    }

    private HeartbeatNioServer initHeartbeatServer(int identifier, boolean useSSL) throws Exception {
        HeartbeatNioServer server = JPPFDriver.startServer(new HeartbeatNioServer(this, identifier, useSSL));
        NioHelper.putServer((int)identifier, (NioServer)server);
        return server;
    }

    public JPPFSystemInformation getSystemInformation() {
        return this.systemInformation;
    }

    public JPPFStatistics getStatistics() {
        return this.statistics;
    }

    public void addDriverDiscovery(PeerDriverDiscovery discovery) {
        this.initializer.discoveryHandler.addDiscovery((DriverDiscovery)discovery);
    }

    public void removeDriverDiscovery(PeerDriverDiscovery discovery) {
        this.initializer.discoveryHandler.removeDiscovery((DriverDiscovery)discovery);
    }

    public boolean isShuttingDown() {
        return this.shuttingDown.get();
    }

    public TypedProperties getConfiguration() {
        return this.configuration;
    }

    public void shutdown() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            this.shutdownNow();
        } else {
            log.info("already Shutting down");
        }
    }

    void shutdownNow() {
        log.info("Shutting down JPPF driver");
        if (debugEnabled) {
            log.debug("closing acceptor");
        }
        if (this.acceptorServer != null) {
            this.acceptorServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("closing node heartbeat server");
        }
        if (this.nodeHeartbeatServer != null) {
            this.nodeHeartbeatServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("client heartbeat server");
        }
        if (this.clientHeartbeatServer != null) {
            this.clientHeartbeatServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("closing client class server");
        }
        if (this.asyncClientClassServer != null) {
            this.asyncClientClassServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("closing node class server");
        }
        if (this.asyncNodeClassServer != null) {
            this.asyncNodeClassServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("closing node job server");
        }
        if (this.asyncNodeNioServer != null) {
            this.asyncNodeNioServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("closing client job server");
        }
        if (this.asyncClientNioServer != null) {
            this.asyncClientNioServer.shutdown();
        }
        if (debugEnabled) {
            log.debug("closing global executor");
        }
        if (this.startedfromMain) {
            NioHelper.shutdown((boolean)true);
        }
        if (debugEnabled) {
            log.debug("closing broadcaster");
        }
        this.initializer.stopBroadcaster();
        if (debugEnabled) {
            log.debug("stopping peer discovery");
        }
        this.initializer.stopPeerDiscoveryThread();
        if (debugEnabled) {
            log.debug("closing JMX server");
        }
        this.initializer.stopJmxServer();
        if (debugEnabled) {
            log.debug("closing job manager");
        }
        this.jobManager.close();
        if (debugEnabled) {
            log.debug("shutdown complete");
        }
    }

    private void initLocalNode() throws Exception {
        TypedProperties configuration;
        AsyncLocalClassLoaderConnection classLoaderConnection = null;
        String uuid = this.configuration.getString("jppf.node.uuid", JPPFUuid.normalUUID());
        boolean secure = (Boolean)(configuration = new TypedProperties((Map)this.configuration)).get(JPPFProperties.SSL_ENABLED);
        configuration.set(JPPFProperties.MANAGEMENT_PORT_NODE, configuration.get(secure ? JPPFProperties.SERVER_SSL_PORT : JPPFProperties.SERVER_PORT));
        AsyncNodeClassContext context = new AsyncNodeClassContext(this.asyncNodeClassServer, null);
        context.setLocal(true);
        classLoaderConnection = new AsyncLocalClassLoaderConnection(uuid, (AsyncLocalNodeClassloaderContext)context);
        this.asyncNodeClassServer.addNodeConnection(uuid, context);
        AsyncNodeContext ctx = new AsyncNodeContext(this.asyncNodeNioServer, null, true);
        ctx.setNodeInfo(this.getSystemInformation(), false);
        this.localNode = new JPPFLocalNode(configuration, new AsyncLocalNodeConnection(ctx), (AbstractClassLoaderConnection<?>)classLoaderConnection);
        ThreadUtils.startDaemonThread((Runnable)this.localNode, (String)"Local node");
        this.asyncNodeNioServer.getMessageHandler().sendHandshakeBundle(ctx, this.asyncNodeNioServer.getHandshakeBundle());
        this.getStatistics().addValue("nodes", 1.0);
    }
}

