/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.discovery.DriverConnectionInfo;
import org.jppf.discovery.DriverDiscoveryHandler;
import org.jppf.discovery.DriverDiscoveryListener;
import org.jppf.server.JPPFDriver;

class PeerDriverDiscoveryListener
implements DriverDiscoveryListener<DriverConnectionInfo> {
    private final Set<DriverConnectionInfo> discoveredPools = new HashSet<DriverConnectionInfo>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final JPPFDriver driver;

    PeerDriverDiscoveryListener(JPPFDriver driver) {
        this.driver = driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onNewConnection(DriverConnectionInfo info) {
        if (this.closed.get()) {
            return false;
        }
        boolean hasPool = false;
        Set<DriverConnectionInfo> set = this.discoveredPools;
        synchronized (set) {
            hasPool = this.discoveredPools.contains(info);
            if (!hasPool) {
                this.discoveredPools.add(info);
            }
        }
        if (!hasPool) {
            JPPFConnectionInformation connectionInfo = DriverDiscoveryHandler.toJPPFConnectionInformation((DriverConnectionInfo)info);
            this.driver.getInitializer().getPeerConnectionPoolHandler().newPool(info.getName(), info.getPoolSize(), connectionInfo, info.isSecure(), false);
        }
        return !hasPool;
    }

    PeerDriverDiscoveryListener open() {
        this.closed.set(false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerDriverDiscoveryListener close() {
        if (this.closed.compareAndSet(true, false)) {
            Set<DriverConnectionInfo> set = this.discoveredPools;
            synchronized (set) {
                this.discoveredPools.clear();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<DriverConnectionInfo> getDiscoveredPools() {
        Set<DriverConnectionInfo> set = this.discoveredPools;
        synchronized (set) {
            return new HashSet<DriverConnectionInfo>(this.discoveredPools);
        }
    }
}

