/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import java.util.TimerTask;
import org.jppf.JPPFError;
import org.jppf.server.JPPFDriver;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShutdownRestartTask
extends TimerTask {
    static Logger log = LoggerFactory.getLogger(ShutdownRestartTask.class);
    private final boolean restart;
    private final long restartDelay;
    private final JPPFDriver driver;
    private final ThreadSynchronization lock = new ThreadSynchronization();

    public ShutdownRestartTask(boolean restart, long restartDelay, JPPFDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("driver is null");
        }
        this.restart = restart;
        this.restartDelay = restartDelay;
        this.driver = driver;
    }

    @Override
    public void run() {
        this.cancel();
        if (this.driver.shuttingDown.compareAndSet(false, true)) {
            log.info("Initiating shutdown");
            this.driver.shutdownNow();
            if (this.driver.startedfromMain || ((Boolean)this.driver.getConfiguration().get(JPPFProperties.SERVER_EXIT_ON_SHUTDOWN)).booleanValue()) {
                if (!this.restart) {
                    log.info("Performing requested exit");
                    System.exit(0);
                } else {
                    try {
                        this.lock.goToSleep(this.restartDelay);
                        log.info("Initiating restart");
                        System.exit(2);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        throw new JPPFError("Could not restart the JPPFDriver");
                    }
                }
            }
        }
    }
}

