/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import org.jppf.management.JPPFSystemInformation;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.stats.JPPFSnapshot;
import org.jppf.utils.stats.JPPFStatisticsEvent;
import org.jppf.utils.stats.JPPFStatisticsHelper;
import org.jppf.utils.stats.JPPFStatisticsListener;

class StatsSystemInformationUpdater
implements JPPFStatisticsListener {
    private final TypedProperties statsProperties;

    StatsSystemInformationUpdater(JPPFSystemInformation info) {
        TypedProperties props = info.getStats();
        this.statsProperties = props == null ? new TypedProperties() : props;
    }

    public void snapshotAdded(JPPFStatisticsEvent event) {
        this.update(event.getSnapshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotRemoved(JPPFStatisticsEvent event) {
        TypedProperties typedProperties = this.statsProperties;
        synchronized (typedProperties) {
            this.statsProperties.remove((Object)event.getSnapshot().getLabel());
        }
    }

    public void snapshotUpdated(JPPFStatisticsEvent event) {
        this.update(event.getSnapshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(JPPFSnapshot snapshot) {
        TypedProperties typedProperties = this.statsProperties;
        synchronized (typedProperties) {
            JPPFStatisticsHelper.toProperties((TypedProperties)this.statsProperties, (JPPFSnapshot)snapshot);
        }
    }
}

