/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jppf.server.protocol.ServerTask;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetHashMap;

public final class DebugHelper {
    private static CollectionMap<String, Integer> resultsMap = new SetHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ServerTask> addResults(String jobUuid, Collection<ServerTask> results) {
        ArrayList<ServerTask> list = null;
        CollectionMap<String, Integer> collectionMap = resultsMap;
        synchronized (collectionMap) {
            Collection positions = resultsMap.getValues((Object)jobUuid);
            if (positions == null) {
                for (ServerTask task : results) {
                    resultsMap.putValue((Object)jobUuid, (Object)task.getPosition());
                }
            } else {
                for (ServerTask task : results) {
                    if (positions.contains(task.getPosition())) {
                        if (list == null) {
                            list = new ArrayList<ServerTask>(results.size());
                        }
                        list.add(task);
                        continue;
                    }
                    resultsMap.putValue((Object)jobUuid, (Object)task.getPosition());
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearResults(String jobUuid) {
        CollectionMap<String, Integer> collectionMap = resultsMap;
        synchronized (collectionMap) {
            resultsMap.removeKey((Object)jobUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showResults() {
        StringBuilder sb = new StringBuilder(resultsMap.getClass().getSimpleName()).append("[");
        CollectionMap<String, Integer> collectionMap = resultsMap;
        synchronized (collectionMap) {
            for (Map.Entry entry : resultsMap.entrySet()) {
                sb.append("\n  ").append((String)entry.getKey()).append('=').append(entry.getValue());
            }
            sb.append("\n]");
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ServerTask> checkResults(String jobUuid, Collection<ServerTask> results) {
        ArrayList<ServerTask> list = null;
        CollectionMap<String, Integer> collectionMap = resultsMap;
        synchronized (collectionMap) {
            Collection positions = resultsMap.getValues((Object)jobUuid);
            if (positions != null) {
                for (ServerTask task : results) {
                    if (!positions.contains(task.getPosition())) continue;
                    if (list == null) {
                        list = new ArrayList<ServerTask>(results.size());
                    }
                    list.add(task);
                }
            }
        }
        return list;
    }
}

