/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.debug;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jppf.JPPFRuntimeException;
import org.jppf.nio.NioContext;
import org.jppf.scripting.JPPFScriptingException;
import org.jppf.scripting.ScriptDefinition;
import org.jppf.server.JPPFDriver;
import org.jppf.server.debug.DebugHelper;
import org.jppf.server.debug.ServerDebugMBean;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.client.AsyncClientContext;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.client.JobEntry;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDebug
implements ServerDebugMBean {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ServerDebug.class);
    private final JPPFDriver driver;

    public ServerDebug(JPPFDriver driver) {
        this.driver = driver;
    }

    @Override
    public String clientClassLoaderChannels() {
        return ServerDebug.viewContexts(this.clientClassLoaderSet());
    }

    @Override
    public String nodeClassLoaderChannels() {
        return ServerDebug.viewContexts(this.nodeClassLoaderSet());
    }

    @Override
    public String nodeDataChannels() {
        return ServerDebug.viewContexts(this.nodeSet());
    }

    @Override
    public String clientDataChannels() {
        Selector selector = this.driver.getAsyncClientNioServer().getSelector();
        HashSet<SelectionKey> keys = new HashSet<SelectionKey>(selector.keys());
        StringBuilder sb = new StringBuilder();
        for (SelectionKey key : keys) {
            sb.append(key.attachment()).append('\n');
        }
        return sb.toString();
    }

    @Override
    public String all() {
        StringBuilder sb = new StringBuilder();
        sb.append("jobs in queue:").append('\n');
        sb.append(this.dumpQueueDetails()).append('\n');
        sb.append('\n').append("node class loader channels:").append('\n');
        sb.append(this.nodeClassLoaderChannels()).append('\n');
        sb.append('\n').append("client class loader channels:").append('\n');
        sb.append(this.clientClassLoaderChannels()).append('\n');
        sb.append('\n').append("node job channels:").append('\n');
        sb.append(this.nodeDataChannels()).append('\n');
        sb.append('\n').append("client job channels:").append('\n');
        sb.append(this.clientDataChannels()).append('\n');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String viewContexts(Set<NioContext> set) {
        StringBuilder sb = new StringBuilder().append(set.size()).append(" channels\n");
        Set<NioContext> set2 = set;
        synchronized (set2) {
            for (NioContext channel : set) {
                sb.append(channel.toString()).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public String allChannels() {
        StringBuilder sb = new StringBuilder();
        sb.append("node class loader channels:").append('\n');
        sb.append(this.nodeClassLoaderChannels()).append('\n');
        sb.append('\n').append("client class loader channels:").append('\n');
        sb.append(this.clientClassLoaderChannels()).append('\n');
        sb.append('\n').append("node job channels:").append('\n');
        sb.append(this.nodeDataChannels()).append('\n');
        sb.append('\n').append("client job channels:").append('\n');
        sb.append(this.clientDataChannels()).append('\n');
        return sb.toString();
    }

    @Override
    public String dumpQueue() {
        JPPFPriorityQueue queue = this.driver.getQueue();
        Set<String> set = queue.getAllJobIds();
        StringBuilder sb = new StringBuilder();
        for (String uuid : set) {
            sb.append(queue.getJob(uuid)).append('\n');
        }
        return sb.toString();
    }

    @Override
    public String dumpQueueDetails() {
        JPPFPriorityQueue queue = this.driver.getQueue();
        return this.dumpJobDetails(queue.getAllJobIds());
    }

    @Override
    public String dumpQueueDetailsFromPriorityMap() {
        JPPFPriorityQueue queue = this.driver.getQueue();
        return this.dumpJobDetails(queue.getAllJobIdsFromPriorityMap());
    }

    private String dumpJobDetails(Set<String> set) {
        JPPFPriorityQueue queue = this.driver.getQueue();
        StringBuilder sb = new StringBuilder();
        String hr = StringUtils.padRight((String)"", (char)'-', (int)80) + '\n';
        for (String uuid : set) {
            ServerJob serverJob = queue.getJob(uuid);
            if (serverJob == null) continue;
            sb.append(hr);
            sb.append(serverJob).append('\n');
            List<ServerTaskBundleClient> bundleList = serverJob.getClientBundles();
            if (bundleList.isEmpty()) {
                sb.append("client bundles: empty\n");
            } else {
                sb.append("client bundles:\n");
                for (ServerTaskBundleClient serverTaskBundleClient : bundleList) {
                    sb.append("- ").append(serverTaskBundleClient).append("\n");
                }
            }
            List<ServerTaskBundleClient> completionBundles = serverJob.getCompletionBundles();
            if (completionBundles.isEmpty()) {
                sb.append("client completion bundles: empty\n");
            } else {
                sb.append("client completion bundles:\n");
                for (ServerTaskBundleClient clientBundle2 : completionBundles) {
                    sb.append("- ").append(clientBundle2).append("\n");
                }
            }
            Set<ServerTaskBundleNode> set2 = serverJob.getDispatchSet();
            if (set2.isEmpty()) {
                sb.append("node bundles: empty\n");
                continue;
            }
            sb.append("node bundles:\n");
            for (ServerTaskBundleNode nodeBundle : set2) {
                sb.append("- ").append(nodeBundle).append("\n");
            }
        }
        return sb.toString();
    }

    private Set<NioContext> clientClassLoaderSet() {
        return new HashSet<AsyncClientClassContext>(this.driver.getAsyncClientClassServer().getAllProviderConnections());
    }

    private Set<NioContext> nodeClassLoaderSet() {
        return new HashSet<AsyncNodeClassContext>(this.driver.getAsyncNodeClassServer().getAllNodeConnections());
    }

    private Set<NioContext> nodeSet() {
        List<BaseNodeContext> list = this.driver.getAsyncNodeNioServer().getAllChannels();
        HashSet<BaseNodeContext> set = new HashSet<BaseNodeContext>(list);
        return set;
    }

    @Override
    public String taskQueueCheckerChannels() {
        List list = this.driver.getAsyncNodeNioServer().getJobScheduler().getIdleChannels();
        StringBuilder sb = new StringBuilder();
        for (BaseNodeContext ctx : list) {
            sb.append((Object)ctx).append('\n');
        }
        return sb.toString();
    }

    @Override
    public String showResultsMap() {
        return DebugHelper.showResults();
    }

    @Override
    public int getJobNotifCount() {
        return this.driver.getJobManager().getNotifCount();
    }

    @Override
    public int getJobNotifPeak() {
        return this.driver.getJobManager().getNotifMax();
    }

    @Override
    public Map<String, Set<String>> getAllReservations() {
        return this.driver.getAsyncNodeNioServer().getNodeReservationHandler().getReservations();
    }

    @Override
    public String[] getReservedJobs() {
        Set<String> set = this.driver.getAsyncNodeNioServer().getNodeReservationHandler().getReservedJobs();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public String[] getReservedNodes() {
        Set<String> set = this.driver.getAsyncNodeNioServer().getNodeReservationHandler().getReservedNodes();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public void log(String ... messages) {
        if (messages != null) {
            for (String message : messages) {
                log.info(message);
            }
        }
    }

    @Override
    public void log(String message) {
        if (message != null) {
            log.info(message);
        }
    }

    @Override
    public Object executeScript(String language, String script) throws JPPFScriptingException {
        try {
            HashMap<String, Object> bindings = new HashMap<String, Object>(){
                {
                    this.put("serverDebug", ServerDebug.this);
                }
            };
            if (log.isTraceEnabled()) {
                log.trace("request to execute {} script with binding={}:\n{}", new Object[]{language, bindings, script});
            }
            Object result = new ScriptDefinition(language, script, (Map)bindings).evaluate();
            if (log.isTraceEnabled()) {
                log.trace("script execution result: {}", result);
            }
            return result;
        }
        catch (JPPFScriptingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JPPFRuntimeException(e);
        }
    }

    @Override
    public void startProfiling() {
        ServerDebug.startProf();
    }

    @Override
    public void endProfiling() {
        ServerDebug.endProf();
    }

    public static void startProf() {
    }

    public static void endProf() {
    }

    public JPPFDriver getDriver() {
        return this.driver;
    }

    @Override
    public String getClientJobEntryStats() {
        return AsyncClientContext.getEntrystats().toString();
    }

    @Override
    public List<String> allClientJobEntries() {
        AsyncClientNioServer server = this.driver.getAsyncClientNioServer();
        Map map = server.performContextAction(context -> context.getEntryMap().size() > 0, null);
        ArrayList<String> result = new ArrayList<String>(map.size());
        int nbEntries = 0;
        for (Map.Entry entry : map.entrySet()) {
            AsyncClientContext context2 = (AsyncClientContext)((Object)entry.getValue());
            Map<String, JobEntry> jobEntries = context2.getEntryMap();
            nbEntries += jobEntries.size();
            StringBuilder sb = new StringBuilder().append(jobEntries.size()).append(" job entries in ").append((Object)context2);
            jobEntries.forEach((id, jobEntry) -> sb.append("\n- ").append(jobEntry));
            result.add(sb.toString());
        }
        result.add("total: " + nbEntries + " entries");
        return result;
    }
}

