/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFNodeConnectionNotifier;
import org.jppf.server.event.NodeConnectionEvent;
import org.jppf.server.event.NodeConnectionListener;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ServiceFinder;
import org.jppf.utils.ServiceProviderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConnectionEventHandler
extends ServiceProviderHandler<NodeConnectionListener> {
    private static Logger log = LoggerFactory.getLogger(NodeConnectionEventHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final AtomicInteger connectedNodes = new AtomicInteger(0);
    private final AtomicInteger connectedPeers = new AtomicInteger(0);
    private final AtomicInteger connectedRealNodes = new AtomicInteger(0);

    public NodeConnectionEventHandler() {
        super(NodeConnectionListener.class);
    }

    public void fireNodeConnected(JPPFManagementInfo info) {
        this.connectedNodes.incrementAndGet();
        if (info.isPeer()) {
            this.connectedPeers.incrementAndGet();
        } else {
            this.connectedRealNodes.incrementAndGet();
        }
        NodeConnectionEvent event = new NodeConnectionEvent(info);
        for (NodeConnectionListener listener : this.providers) {
            listener.nodeConnected(event);
        }
        JPPFNodeConnectionNotifier.getInstance().onNodeConnected(info);
    }

    public void fireNodeDisconnected(JPPFManagementInfo info) {
        this.connectedNodes.decrementAndGet();
        if (info.isPeer()) {
            this.connectedPeers.decrementAndGet();
        } else {
            this.connectedRealNodes.decrementAndGet();
        }
        NodeConnectionEvent event = new NodeConnectionEvent(info);
        for (NodeConnectionListener listener : this.providers) {
            listener.nodeDisconnected(event);
        }
        JPPFNodeConnectionNotifier.getInstance().onNodeDisconnected(info);
    }

    public void loadListeners() {
        Iterator it = ServiceFinder.lookupProviders(NodeConnectionListener.class);
        ArrayList<NodeConnectionListener> list = new ArrayList<NodeConnectionListener>();
        while (it.hasNext()) {
            NodeConnectionListener listener = (NodeConnectionListener)it.next();
            if (listener == null) continue;
            list.add(listener);
            if (!debugEnabled) continue;
            log.debug("successfully added node connection listener " + listener.getClass().getName());
        }
        this.providers.addAll(list);
    }

    public int getConnectedNodes() {
        return this.connectedNodes.get();
    }

    public int getConnectedPeers() {
        return this.connectedPeers.get();
    }

    public int getConnectedRealNodes() {
        return this.connectedRealNodes.get();
    }
}

