/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jppf.execute.ExecutorChannel;
import org.jppf.job.JobEventType;
import org.jppf.job.JobInformation;
import org.jppf.job.JobManagerListener;
import org.jppf.job.JobNotification;
import org.jppf.job.JobNotificationEmitter;
import org.jppf.job.JobReturnReason;
import org.jppf.job.JobTasksEvent;
import org.jppf.job.JobTasksListener;
import org.jppf.job.JobTasksListenerManager;
import org.jppf.job.ServerTaskInformation;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.JPPFDriver;
import org.jppf.server.job.ChannelJobPair;
import org.jppf.server.nio.nodeserver.NodeReservationHandler;
import org.jppf.server.protocol.AbstractServerJob;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerJobBroadcast;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ServiceFinder;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.concurrent.QueueHandler;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFJobManager
implements ServerJobChangeListener,
JobNotificationEmitter,
JobTasksListenerManager {
    private static final Logger log = LoggerFactory.getLogger(JPPFJobManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final CollectionMap<String, ChannelJobPair> jobMap = new ArrayListHashMap();
    private final List<JobManagerListener> jobManagerListeners = new CopyOnWriteArrayList<JobManagerListener>();
    private final List<JobTasksListener> taskReturnListeners = new CopyOnWriteArrayList<JobTasksListener>();
    private final JPPFDriver driver;
    private final QueueHandler<JobNotification> eventQueue;

    public JPPFJobManager(JPPFDriver driver) {
        this.driver = driver;
        TypedProperties config = driver.getConfiguration();
        int size = (Integer)config.get(JPPFProperties.JMX_NOTIF_QUEUE_SIZE);
        if (size <= 0) {
            size = Integer.MAX_VALUE;
        }
        this.eventQueue = QueueHandler.builder().named("JobNotifications").withCapacity(size).handlingElementsAs(this::fireJobEvent).usingSingleDequuerThread().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelJobPair> getNodesForJob(String jobUuid) {
        if (jobUuid == null) {
            return Collections.emptyList();
        }
        CollectionMap<String, ChannelJobPair> collectionMap = this.jobMap;
        synchronized (collectionMap) {
            List list = (List)this.jobMap.getValues((Object)jobUuid);
            return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllJobIds() {
        CollectionMap<String, ChannelJobPair> collectionMap = this.jobMap;
        synchronized (collectionMap) {
            Set keys = this.jobMap.keySet();
            if (debugEnabled) {
                log.debug("keys = {}", (Object)keys);
            }
            return keys.toArray(new String[keys.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobDispatched(AbstractServerJob serverJob, ExecutorChannel<?> channel, ServerTaskBundleNode nodeBundle) {
        TaskBundle bundle = nodeBundle.getJob();
        String jobUuid = bundle.getUuid();
        CollectionMap<String, ChannelJobPair> collectionMap = this.jobMap;
        synchronized (collectionMap) {
            this.jobMap.putValue((Object)jobUuid, (Object)new ChannelJobPair(channel, serverJob));
        }
        if (debugEnabled) {
            log.debug("job '{}' dispatched to node {}", (Object)bundle.getName(), channel);
        }
        if (!JPPFJobManager.isBroadcastDispatch(serverJob)) {
            this.submitEvent(JobEventType.JOB_DISPATCHED, bundle, channel);
            this.fireJobTasksEvent(channel, nodeBundle, true);
        } else {
            ServerJobBroadcast broadcast = (ServerJobBroadcast)serverJob;
            this.submitEvent(JobEventType.JOB_DISPATCHED, broadcast.getParentJob(), channel);
        }
        JPPFStatistics stats = this.driver.getStatistics();
        stats.addValue("job.dispatch.total", 1.0);
        stats.addValue("job.dispatch.count", 1.0);
        stats.addValue("job.dispatch.tasks", (double)nodeBundle.getTaskCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void jobReturned(AbstractServerJob serverJob, ExecutorChannel<?> channel, ServerTaskBundleNode nodeBundle) {
        TaskBundle bundle = nodeBundle.getJob();
        String jobUuid = bundle.getUuid();
        if (debugEnabled) {
            log.debug("job '{}' returned from node {}", (Object)bundle.getName(), channel);
        }
        CollectionMap<String, ChannelJobPair> collectionMap = this.jobMap;
        synchronized (collectionMap) {
            this.jobMap.removeValue((Object)jobUuid, (Object)new ChannelJobPair(channel, serverJob));
        }
        if (!JPPFJobManager.isBroadcastDispatch(serverJob)) {
            this.submitEvent(JobEventType.JOB_RETURNED, bundle, channel);
            this.fireJobTasksEvent(channel, nodeBundle, false);
        } else {
            ServerJobBroadcast broadcast = (ServerJobBroadcast)serverJob;
            this.submitEvent(JobEventType.JOB_RETURNED, broadcast.getParentJob(), channel);
        }
        JPPFStatistics stats = this.driver.getStatistics();
        stats.addValue("job.dispatch.count", -1.0);
        stats.addValue("job.dispatch.time", (double)(System.currentTimeMillis() - nodeBundle.getDispatchStartTime()));
    }

    public void jobQueued(ServerJob serverJob) {
        TaskBundle bundle = serverJob.getJob();
        if (debugEnabled) {
            log.debug("jobId '{}' queued", (Object)bundle.getName());
        }
        if (!JPPFJobManager.isBroadcastDispatch(serverJob)) {
            this.submitEvent(JobEventType.JOB_QUEUED, serverJob, null);
        }
        JPPFStatistics stats = this.driver.getStatistics();
        stats.addValue("job.total", 1.0);
        stats.addValue("job.count", 1.0);
        stats.addValue("job.tasks", (double)bundle.getTaskCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobEnded(ServerJob serverJob) {
        if (serverJob == null) {
            throw new IllegalArgumentException("bundleWrapper is null");
        }
        TaskBundle bundle = serverJob.getJob();
        if (bundle.isHandshake()) {
            return;
        }
        long time = System.currentTimeMillis() - serverJob.getJobReceivedTime();
        String jobUuid = bundle.getUuid();
        CollectionMap<String, ChannelJobPair> collectionMap = this.jobMap;
        synchronized (collectionMap) {
            this.jobMap.removeValues((Object)jobUuid, (Object[])new ChannelJobPair[0]);
        }
        if (debugEnabled) {
            log.debug("jobId '{}' ended", (Object)bundle.getName());
        }
        if (serverJob.getSLA().getDesiredNodeConfiguration() != null) {
            NodeReservationHandler handler = this.driver.getAsyncNodeNioServer().getNodeReservationHandler();
            handler.removeJobReservations(serverJob.getUuid());
        }
        if (!JPPFJobManager.isBroadcastDispatch(serverJob)) {
            this.submitEvent(JobEventType.JOB_ENDED, serverJob, null);
        }
        JPPFStatistics stats = this.driver.getStatistics();
        stats.addValue("job.count", -1.0);
        stats.addValue("job.time", (double)time);
        stats.addValue("dispatch.per.job.count", (double)serverJob.getTotalDispatches());
    }

    @Override
    public void jobUpdated(AbstractServerJob job, boolean headerUpdated) {
        if (headerUpdated) {
            this.driver.getQueue().getPersistenceHandler().updateJobHeader((ServerJob)job);
        }
        this.submitEvent(JobEventType.JOB_UPDATED, (ServerJob)job, null);
    }

    @Override
    public void jobStatusChanged(AbstractServerJob source, SubmissionStatus oldValue, SubmissionStatus newValue) {
    }

    private void submitEvent(JobEventType eventType, TaskBundle bundle, ExecutorChannel<?> channel) {
        try {
            this.eventQueue.put((Object)JPPFJobManager.newJobNotification(this, eventType, bundle, null, channel));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void submitEvent(JobEventType eventType, ServerJob job, ExecutorChannel<?> channel) {
        try {
            this.eventQueue.put((Object)JPPFJobManager.newJobNotification(this, eventType, null, job, channel));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static JobNotification newJobNotification(JobNotificationEmitter jobManager, JobEventType eventType, TaskBundle bundle, ServerJob job, ExecutorChannel<?> channel) {
        JobInformation jobInfo;
        JobSLA sla;
        if (job != null) {
            sla = job.getSLA();
            jobInfo = new JobInformation(job.getUuid(), job.getName(), job.getTaskCount(), job.getInitialTaskCount(), sla.getPriority(), job.isSuspended(), job.isPending());
        } else {
            sla = bundle.getSLA();
            jobInfo = new JobInformation(bundle.getUuid(), bundle.getName(), bundle.getCurrentTaskCount(), bundle.getInitialTaskCount(), sla.getPriority(), sla.isSuspended(), ((Boolean)bundle.getParameter((Object)BundleParameter.JOB_PENDING, (Object)false)).booleanValue());
        }
        jobInfo.setMaxNodes(sla.getMaxNodes());
        JPPFManagementInfo nodeInfo = channel == null ? null : channel.getManagementInfo();
        return new JobNotification(jobManager.getEmitterUuid(), eventType, jobInfo, nodeInfo, System.currentTimeMillis());
    }

    public synchronized void close() {
        this.eventQueue.close();
        this.jobMap.clear();
    }

    public void addJobManagerListener(JobManagerListener listener) {
        this.jobManagerListeners.add(listener);
    }

    public void removeJobManagerListener(JobManagerListener listener) {
        this.jobManagerListeners.remove(listener);
    }

    public void fireJobEvent(JobNotification event) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        switch (event.getEventType()) {
            case JOB_QUEUED: {
                for (JobManagerListener listener : this.jobManagerListeners) {
                    listener.jobQueued(event);
                }
                break;
            }
            case JOB_ENDED: {
                for (JobManagerListener listener : this.jobManagerListeners) {
                    listener.jobEnded(event);
                }
                break;
            }
            case JOB_UPDATED: {
                for (JobManagerListener listener : this.jobManagerListeners) {
                    listener.jobUpdated(event);
                }
                break;
            }
            case JOB_DISPATCHED: {
                for (JobManagerListener listener : this.jobManagerListeners) {
                    listener.jobDispatched(event);
                }
                break;
            }
            case JOB_RETURNED: {
                for (JobManagerListener listener : this.jobManagerListeners) {
                    listener.jobReturned(event);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported event type: " + event.getEventType());
            }
        }
    }

    public String getEmitterUuid() {
        return this.driver.getUuid();
    }

    public void addJobTasksListener(JobTasksListener listener) {
        if (debugEnabled) {
            log.debug("adding JobTasksListener {}", (Object)listener);
        }
        this.taskReturnListeners.add(listener);
    }

    public void removeJobTasksListener(JobTasksListener listener) {
        if (debugEnabled) {
            log.debug("removing JobTasksListener {}", (Object)listener);
        }
        this.taskReturnListeners.remove(listener);
    }

    public synchronized void jobResultsReceived(ExecutorChannel<?> channel, ServerJob job, Collection<ServerTask> tasks) {
        this.driver.getQueue().getPersistenceHandler().storeResults(job, tasks);
        if (!this.taskReturnListeners.isEmpty()) {
            if (debugEnabled) {
                log.debug("results received with channel={}, job={}, nb Tasks={}", new Object[]{channel, job, tasks.size()});
            }
            JobTasksEvent event = JPPFJobManager.createJobTasksEvent(channel, job, tasks);
            for (JobTasksListener listener : this.taskReturnListeners) {
                listener.resultsReceived(event);
            }
        }
    }

    private void fireJobTasksEvent(ExecutorChannel<?> channel, ServerTaskBundleNode nodeBundle, boolean isDispatch) {
        block4: {
            if (this.taskReturnListeners.isEmpty()) break block4;
            JobTasksEvent event = JPPFJobManager.createJobTasksEvent(channel, nodeBundle);
            if (isDispatch) {
                for (JobTasksListener listener : this.taskReturnListeners) {
                    listener.tasksDispatched(event);
                }
            } else {
                for (JobTasksListener listener : this.taskReturnListeners) {
                    listener.tasksReturned(event);
                }
            }
        }
    }

    private static JobTasksEvent createJobTasksEvent(ExecutorChannel<?> channel, ServerTaskBundleNode nodeBundle) {
        List<ServerTask> tasks = nodeBundle.getTaskList();
        ArrayList<ServerTaskInformation> taskInfos = new ArrayList<ServerTaskInformation>(tasks.size());
        for (ServerTask task : tasks) {
            taskInfos.add(new ServerTaskInformation(task.getPosition(), task.getThrowable(), task.getExpirationCount(), task.getMaxResubmits(), task.getTaskResubmitCount(), task.getResult()));
        }
        TaskBundle job = nodeBundle.getJob();
        return new JobTasksEvent(job.getUuid(), job.getName(), job.getSLA(), job.getMetadata(), taskInfos, nodeBundle.getJobReturnReason(), channel.getManagementInfo());
    }

    private static JobTasksEvent createJobTasksEvent(ExecutorChannel<?> channel, ServerJob job, Collection<ServerTask> tasks) {
        ArrayList<ServerTaskInformation> taskInfos = new ArrayList<ServerTaskInformation>(tasks.size());
        for (ServerTask task : tasks) {
            taskInfos.add(new ServerTaskInformation(task.getPosition(), task.getThrowable(), task.getExpirationCount(), task.getMaxResubmits(), task.getTaskResubmitCount(), task.getResult()));
        }
        return new JobTasksEvent(job.getUuid(), job.getName(), job.getSLA(), job.getMetadata(), taskInfos, JobReturnReason.RESULTS_RECEIVED, channel.getManagementInfo());
    }

    public void loadTaskReturnListeners() {
        if (debugEnabled) {
            log.debug("loading task return listeners");
        }
        List list2 = new ServiceFinder().findProviders(JobTasksListener.class);
        for (JobTasksListener listener : list2) {
            this.addJobTasksListener(listener);
        }
    }

    public int getNotifCount() {
        return this.eventQueue.size();
    }

    public int getNotifMax() {
        return this.eventQueue.getPeakSize();
    }

    public static boolean isBroadcastDispatch(AbstractServerJob job) {
        if (!(job instanceof ServerJobBroadcast)) {
            return false;
        }
        return job.getBroadcastUUID() != null;
    }
}

