/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.job.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jppf.job.JobEventType;
import org.jppf.job.JobInformation;
import org.jppf.job.JobManagerListener;
import org.jppf.job.JobNotification;
import org.jppf.job.JobSelector;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.server.JPPFDriver;
import org.jppf.server.job.JPPFJobManager;
import org.jppf.server.job.management.DriverJobManagementMBean;
import org.jppf.server.job.management.NodeJobInformation;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerJobBroadcast;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverJobManagement
extends NotificationBroadcasterSupport
implements DriverJobManagementMBean {
    private static final Logger log = LoggerFactory.getLogger(DriverJobManagement.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFDriver driver;

    public DriverJobManagement(JPPFDriver driver) {
        this.driver = driver;
        driver.getJobManager().addJobManagerListener(new JobEventNotifier());
    }

    public void cancelJob(String jobUuid) throws Exception {
        this.cancelJob(this.getServerJob(jobUuid));
    }

    private void cancelJob(ServerJob job) throws Exception {
        if (job != null) {
            if (debugEnabled) {
                log.debug("Request to cancel job '{}'", (Object)job.getName());
            }
            job.cancel(this.driver, false);
            JPPFStatistics stats = this.driver.getStatistics();
            stats.addValue("task.queue.count", (double)(-job.getTaskCount()));
        } else if (debugEnabled) {
            log.debug("job is null");
        }
    }

    public void suspendJob(String jobUuid, Boolean requeue) throws Exception {
        DriverJobManagement.suspendJob(this.getServerJob(jobUuid), requeue);
    }

    private static void suspendJob(ServerJob job, Boolean requeue) throws Exception {
        if (job == null) {
            if (debugEnabled) {
                log.debug("job is null");
            }
            return;
        }
        if (debugEnabled) {
            log.debug("Request to suspend job '" + job.getName() + '\'');
        }
        job.setSuspended(true, requeue);
    }

    public void resumeJob(String jobUuid) throws Exception {
        this.resumeJob(this.getServerJob(jobUuid));
    }

    private void resumeJob(ServerJob job) throws Exception {
        if (job == null) {
            if (debugEnabled) {
                log.debug("job is null");
            }
            return;
        }
        if (debugEnabled) {
            log.debug("Request to resume job '" + job.getName() + '\'');
        }
        job.setSuspended(false, false);
        this.driver.getAsyncNodeNioServer().getJobScheduler().wakeUp();
    }

    public void updateMaxNodes(String jobUuid, Integer maxNodes) throws Exception {
        DriverJobManagement.updateMaxNodes(this.getServerJob(jobUuid), maxNodes);
    }

    private static void updateMaxNodes(ServerJob job, Integer maxNodes) throws Exception {
        if (job == null) {
            if (debugEnabled) {
                log.debug("job is null");
            }
            return;
        }
        if (debugEnabled) {
            log.debug("Request to update maxNodes to " + maxNodes + " for jobId = '" + job.getName() + '\'');
        }
        job.setMaxNodes(maxNodes);
    }

    public String[] getAllJobUuids() throws Exception {
        Set<String> ids = this.driver.getQueue().getAllJobIds();
        return ids.toArray(new String[ids.size()]);
    }

    public JobInformation getJobInformation(String jobUuid) throws Exception {
        ServerJob job = this.getServerJob(jobUuid);
        if (job == null) {
            return null;
        }
        JobInformation jobInfo = new JobInformation(jobUuid, job.getName(), job.getTaskCount(), job.getInitialTaskCount(), job.getSLA().getPriority(), job.isSuspended(), job.isPending());
        jobInfo.setMaxNodes(job.getSLA().getMaxNodes());
        return jobInfo;
    }

    public NodeJobInformation[] getNodeInformation(String jobUuid) throws Exception {
        return DriverJobManagement.getNodeInformation(this.getServerJob(jobUuid));
    }

    private static NodeJobInformation[] getNodeInformation(ServerJob job) throws Exception {
        if (job == null) {
            return NodeJobInformation.EMPTY_ARRAY;
        }
        if (!(job instanceof ServerJobBroadcast)) {
            return job.getNodeJobInformation();
        }
        ServerJobBroadcast broadcast = (ServerJobBroadcast)job;
        List<ServerJobBroadcast> dispatches = broadcast.getDispatchedBroadcasts();
        ArrayList<NodeJobInformation> result = new ArrayList<NodeJobInformation>(dispatches.size());
        for (ServerJobBroadcast childJob : dispatches) {
            NodeJobInformation[] nji = childJob.getNodeJobInformation();
            if (nji == null) continue;
            for (NodeJobInformation info : nji) {
                result.add(info);
            }
        }
        return result.toArray(new NodeJobInformation[result.size()]);
    }

    public void updatePriority(String jobUuid, Integer newPriority) {
        if (debugEnabled) {
            log.debug("Updating priority of jobId = '" + jobUuid + "' to: " + newPriority);
        }
        this.driver.getQueue().updatePriority(jobUuid, newPriority);
    }

    @Override
    public void sendNotification(Notification notification) {
        JobNotification event;
        if (debugEnabled && notification instanceof JobNotification && (event = (JobNotification)notification).getEventType() != JobEventType.JOB_UPDATED) {
            log.debug("sending event {} for job {}, node={}", new Object[]{event.getEventType(), event.getJobInformation(), event.getNodeInfo()});
        }
        super.sendNotification(notification);
    }

    public void cancelJobs(JobSelector selector) throws Exception {
        List<ServerJob> jobs = this.selectJobs(selector);
        if (debugEnabled) {
            log.debug("request to cancel {} jobs, job selector = {}", (Object)jobs.size(), (Object)selector);
        }
        for (ServerJob job : jobs) {
            this.cancelJob(job);
        }
    }

    public void suspendJobs(JobSelector selector, Boolean requeue) throws Exception {
        for (ServerJob job : this.selectJobs(selector)) {
            DriverJobManagement.suspendJob(job, requeue);
        }
    }

    public void resumeJobs(JobSelector selector) throws Exception {
        for (ServerJob job : this.selectJobs(selector)) {
            this.resumeJob(job);
        }
    }

    public void updateMaxNodes(JobSelector selector, Integer maxNodes) throws Exception {
        for (ServerJob job : this.selectJobs(selector)) {
            DriverJobManagement.updateMaxNodes(job, maxNodes);
        }
    }

    public JobInformation[] getJobInformation(JobSelector selector) throws Exception {
        HashSet<JobInformation> result = new HashSet<JobInformation>();
        List<ServerJob> jobs = this.selectJobs(selector);
        for (ServerJob job : jobs) {
            if (JPPFJobManager.isBroadcastDispatch(job)) continue;
            JobInformation info = this.getJobInformation(job.getUuid());
            result.add(info);
        }
        return result.toArray(new JobInformation[result.size()]);
    }

    public Map<String, NodeJobInformation[]> getNodeInformation(JobSelector selector) throws Exception {
        HashMap<String, NodeJobInformation[]> result = new HashMap<String, NodeJobInformation[]>();
        List<ServerJob> jobs = this.selectJobs(selector);
        for (ServerJob job : jobs) {
            NodeJobInformation[] info;
            if (JPPFJobManager.isBroadcastDispatch(job) || (info = DriverJobManagement.getNodeInformation(job)) == null) continue;
            result.put(job.getUuid(), info);
        }
        return result;
    }

    public void updatePriority(JobSelector selector, Integer newPriority) {
        for (ServerJob job : this.selectJobs(selector)) {
            this.updatePriority(job.getUuid(), newPriority);
        }
    }

    private List<ServerJob> selectJobs(JobSelector selector) {
        JPPFPriorityQueue queue = this.driver.getQueue();
        List<ServerJob> allJobs = queue.getAllJobs();
        ArrayList<ServerJob> list = new ArrayList<ServerJob>(allJobs.size());
        for (ServerJob job : allJobs) {
            if (!selector.accepts((JPPFDistributedJob)job) || JPPFJobManager.isBroadcastDispatch(job)) continue;
            list.add(job);
        }
        return list;
    }

    private ServerJob getServerJob(String jobUuid) {
        return this.driver.getQueue().getBundleForJob(jobUuid);
    }

    public void updateJobs(JobSelector selector, JobSLA sla, JobMetadata metadata) {
        if (sla == null && metadata == null) {
            return;
        }
        JPPFPriorityQueue queue = this.driver.getQueue();
        List<ServerJob> jobs = queue.selectJobs(selector);
        if (debugEnabled) {
            log.debug("updating sla and metadata for " + jobs.size() + " jobs");
        }
        if (jobs.isEmpty()) {
            return;
        }
        int newPriority = 0;
        if (sla != null) {
            newPriority = sla.getPriority();
        }
        for (ServerJob job : jobs) {
            int oldPriority;
            if (debugEnabled) {
                log.debug("updating sla and metadata for job " + job.getName());
            }
            if (sla != null && (oldPriority = job.getSLA().getPriority()) != newPriority) {
                queue.updatePriority(job.getUuid(), newPriority);
            }
            job.update(this.driver, sla, metadata);
        }
        this.driver.getAsyncNodeNioServer().getJobScheduler().wakeUp();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (debugEnabled) {
            log.debug("adding notification listener={} with filter={} and handback={}", new Object[]{listener, filter, handback});
        }
        super.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (debugEnabled) {
            log.debug("removing notification listener=" + listener);
        }
        super.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (debugEnabled) {
            log.debug("removing notification listener={} with filter={} and handback={}", new Object[]{listener, filter, handback});
        }
        super.removeNotificationListener(listener, filter, handback);
    }

    private class JobEventNotifier
    implements JobManagerListener {
        private JobEventNotifier() {
        }

        public void jobQueued(JobNotification event) {
            DriverJobManagement.this.sendNotification((Notification)event);
        }

        public void jobEnded(JobNotification event) {
            DriverJobManagement.this.sendNotification((Notification)event);
        }

        public void jobUpdated(JobNotification event) {
            DriverJobManagement.this.sendNotification((Notification)event);
        }

        public void jobDispatched(JobNotification event) {
            DriverJobManagement.this.sendNotification((Notification)event);
        }

        public void jobReturned(JobNotification event) {
            DriverJobManagement.this.sendNotification((Notification)event);
        }
    }
}

