/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.job.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jppf.job.JobSelector;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.graph.JobDependencyGraph;
import org.jppf.node.protocol.graph.JobDependencyGraphImpl;
import org.jppf.node.protocol.graph.JobDependencyNode;
import org.jppf.node.protocol.graph.MutableJobDependencyGraph;
import org.jppf.server.JPPFDriver;
import org.jppf.server.job.management.JobDependencyManagerMBean;

public class JobDependencyManager
implements JobDependencyManagerMBean {
    final JPPFDriver driver;
    private final MutableJobDependencyGraph graph;

    public JobDependencyManager(JPPFDriver driver) {
        this.driver = driver;
        this.graph = driver.getQueue().getDependenciesHandler().getGraph();
    }

    public int getGraphSize() {
        return this.graph.getSize();
    }

    public Set<String> getNodeIds() {
        return this.graph.getNodeIds();
    }

    public Collection<JobDependencyNode> getAllNodes() {
        return this.graph.getAllNodes();
    }

    public Collection<JobDependencyNode> getQueuedNodes() {
        return this.graph.getQueuedNodes();
    }

    public Collection<JobDependencyNode> getQueuedNodes(JobSelector selector) {
        Collection queuedNodes = this.graph.getQueuedNodes();
        if (selector == null) {
            return queuedNodes;
        }
        ArrayList<JobDependencyNode> result = new ArrayList<JobDependencyNode>(queuedNodes.size());
        for (JobDependencyNode node : queuedNodes) {
            JPPFDistributedJob job;
            String uuid = node.getJobUuid();
            if (uuid == null || (job = this.driver.getJob(uuid)) == null || !selector.accepts(job)) continue;
            result.add(node);
        }
        return result;
    }

    public JobDependencyNode getNode(String id) {
        return this.graph.getNode(id);
    }

    public JobDependencyGraph getGraph() {
        return new JobDependencyGraphImpl(this.graph.getAllNodes());
    }
}

