/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.nio.AbstractNioContext;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.nio.NioContext;
import org.jppf.nio.StatelessNioServer;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.server.JPPFDriver;

public abstract class AbstractAsyncClassContext
extends AbstractNioContext {
    protected final JPPFDriver driver;
    private final StatelessNioServer<? extends AbstractAsyncClassContext> server;
    protected final BlockingQueue<ClassLoaderNioMessage> sendQueue = new LinkedBlockingQueue<ClassLoaderNioMessage>();

    public AbstractAsyncClassContext(JPPFDriver driver, StatelessNioServer<? extends AbstractAsyncClassContext> server) {
        this.server = server;
        this.driver = driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFResourceWrapper deserializeResource(ClassLoaderNioMessage message) throws Exception {
        if (this.local) {
            return message.getResource();
        }
        DataLocation dl = (DataLocation)message.getLocations().get(0);
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        JPPFResourceWrapper resource = null;
        try {
            currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            resource = (JPPFResourceWrapper)IOHelper.unwrappedData((DataLocation)dl, (ObjectSerializer)this.driver.getSerializer());
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
        return resource;
    }

    public ClassLoaderNioMessage serializeResource(JPPFResourceWrapper resource) throws Exception {
        ClassLoaderNioMessage message = new ClassLoaderNioMessage((NioContext)this, resource);
        if (!this.local) {
            DataLocation location = IOHelper.serializeData((Object)resource, (ObjectSerializer)this.driver.getSerializer());
            message.addLocation(location);
        }
        return message;
    }

    protected abstract boolean isProvider();

    public boolean readMessage() throws Exception {
        if (this.readMessage == null) {
            this.readMessage = new ClassLoaderNioMessage((NioContext)this);
        }
        this.readByteCount = this.readMessage.getChannelReadCount();
        boolean b = false;
        try {
            b = this.readMessage.read();
        }
        catch (Exception e) {
            this.updateInTrafficStats();
            throw e;
        }
        this.readByteCount = this.readMessage.getChannelReadCount() - this.readByteCount;
        if (b) {
            this.updateInTrafficStats();
        }
        return b;
    }

    public boolean writeMessage() throws Exception {
        this.writeByteCount = this.writeMessage.getChannelWriteCount();
        boolean b = false;
        try {
            b = this.writeMessage.write();
        }
        catch (Exception e) {
            this.updateOutTrafficStats();
            throw e;
        }
        this.writeByteCount = this.writeMessage.getChannelWriteCount() - this.writeByteCount;
        if (b) {
            this.updateOutTrafficStats();
        }
        return b;
    }

    private void updateInTrafficStats() {
        if (this.readMessage != null) {
            double value;
            if (this.inSnapshot == null) {
                this.inSnapshot = this.driver.getStatistics().getSnapshot(this.peer ? "peer.traffic.in" : (this.isProvider() ? "client.traffic.in" : "node.traffic.in"));
            }
            if ((value = (double)this.readMessage.getChannelReadCount()) > 0.0) {
                this.inSnapshot.addValues(value, 1L);
            }
        }
    }

    private void updateOutTrafficStats() {
        if (this.writeMessage != null) {
            double value;
            if (this.outSnapshot == null) {
                this.outSnapshot = this.driver.getStatistics().getSnapshot(this.peer ? "peer.traffic.out" : (this.isProvider() ? "client.traffic.out" : "node.traffic.out"));
            }
            if ((value = (double)this.writeMessage.getChannelWriteCount()) > 0.0) {
                this.outSnapshot.addValues(value, 1L);
            }
        }
    }

    public static String getResourceName(JPPFResourceWrapper resource) {
        StringBuilder sb = new StringBuilder();
        if (resource.getData(ResourceIdentifier.MULTIPLE) != null) {
            sb.append(ResourceIdentifier.MULTIPLE).append('.').append(resource.getName());
        } else if (resource.getData(ResourceIdentifier.MULTIPLE_NAMES) != null) {
            sb.append(ResourceIdentifier.MULTIPLE_NAMES).append('[').append(resource.getName());
            String[] names = (String[])resource.getData(ResourceIdentifier.MULTIPLE_NAMES);
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(names[i]);
            }
            sb.append(']');
        } else if (resource.getData(ResourceIdentifier.CALLABLE) != null) {
            sb.append(resource.getData(ResourceIdentifier.DRIVER_CALLABLE_ID));
        } else {
            sb.append(resource.getName());
        }
        return sb.toString();
    }

    public StatelessNioServer<? extends AbstractAsyncClassContext> getServer() {
        return this.server;
    }

    protected ClassLoaderNioMessage nextMessageToSend() {
        return (ClassLoaderNioMessage)this.sendQueue.poll();
    }
}

