/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;

public class AsyncResourceRequest {
    private static final ResourceIdentifier[] RESOURCE_IDS = new ResourceIdentifier[]{ResourceIdentifier.DEFINITION, ResourceIdentifier.RESOURCE_LIST, ResourceIdentifier.RESOURCE_MAP};
    private final AsyncNodeClassContext context;
    private JPPFResourceWrapper resource;
    private long requestStartTime = System.nanoTime();

    public AsyncResourceRequest(AsyncNodeClassContext context, JPPFResourceWrapper resource) {
        this.context = context;
        this.resource = resource;
    }

    public AsyncNodeClassContext getContext() {
        return this.context;
    }

    public JPPFResourceWrapper getResource() {
        return this.resource;
    }

    public void setResource(JPPFResourceWrapper resource) {
        Object o = null;
        for (ResourceIdentifier id : RESOURCE_IDS) {
            o = resource.getData(id);
            if (o == null) continue;
            this.resource.setData(id, o);
        }
        long callableId = resource.getCallableID();
        if (callableId == this.resource.getCallableID() && callableId >= 0L) {
            byte[] byArray = resource.getCallable();
            o = byArray;
            if (byArray != null) {
                this.resource.setCallable((byte[])o);
            }
        }
        this.resource.setState(resource.getState());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("context=").append((Object)this.context);
        sb.append(", resource=").append(this.resource);
        sb.append(']');
        return sb.toString();
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    public void setRequestStartTime(long requestStartTime) {
        this.requestStartTime = requestStartTime;
    }
}

