/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader;

import java.util.Map;
import org.jppf.server.nio.classloader.CacheClassContent;
import org.jppf.server.nio.classloader.CacheClassKey;
import org.jppf.utils.ReflectionUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.collections.SoftReferenceValuesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassCache {
    private static Logger log = LoggerFactory.getLogger(ClassCache.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private final Map<CacheClassKey, CacheClassContent> classCache = new SoftReferenceValuesMap();
    private long nbLookups;
    private long nbHits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheContent(String uuid, String name, byte[] content) {
        if (traceEnabled) {
            log.trace("adding cache entry with key=[" + uuid + ", " + name + ']');
        }
        CacheClassContent cacheContent = new CacheClassContent(content);
        CacheClassKey cacheKey = new CacheClassKey(uuid, name);
        Map<CacheClassKey, CacheClassContent> map = this.classCache;
        synchronized (map) {
            this.classCache.put(cacheKey, cacheContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCacheContent(String uuid, String name) {
        boolean contentNull;
        CacheClassContent content;
        Map<CacheClassKey, CacheClassContent> map = this.classCache;
        synchronized (map) {
            content = this.classCache.get((Object)new CacheClassKey(uuid, name));
            contentNull = content == null;
            ++this.nbLookups;
            if (!contentNull) {
                ++this.nbHits;
            }
            if (traceEnabled) {
                log.trace(StringUtils.build((Object[])new Object[]{"nbLookups=", this.nbLookups, ", nbHits=", this.nbHits, ", lookup for key=[", uuid, ", ", name, "] : ", ReflectionUtils.simpleDump((Object)content)}));
            }
        }
        return contentNull ? null : content.getContent();
    }
}

