/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.client;

import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.server.nio.classloader.AbstractAsyncClassContext;
import org.jppf.server.nio.classloader.AsyncResourceRequest;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientClassContext
extends AbstractAsyncClassContext {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientClassContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final CollectionMap<JPPFResourceWrapper, AsyncResourceRequest> requestMap = new ArrayListHashMap();

    AsyncClientClassContext(AsyncClientClassNioServer server, SocketChannel socketChannel) {
        super(server.getDriver(), server);
        this.socketChannel = socketChannel;
    }

    public void handleException(Exception e) {
        if (this.getClosed().compareAndSet(false, true)) {
            if (debugEnabled) {
                log.debug("handling exception on {}:{}", (Object)this, (Object)(e == null ? " null" : "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
            }
            this.getServer().closeConnection(this);
            this.handleProviderError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProviderError() {
        try {
            ArrayList pendingList;
            CollectionMap<JPPFResourceWrapper, AsyncResourceRequest> collectionMap = this.requestMap;
            synchronized (collectionMap) {
                pendingList = new ArrayList(this.requestMap.allValues());
                this.requestMap.clear();
            }
            if (!pendingList.isEmpty()) {
                if (debugEnabled) {
                    log.debug("provider: {} sending null response(s) for disconnected provider", (Object)this);
                }
                for (AsyncResourceRequest request : pendingList) {
                    request.getResource().setState(JPPFResourceWrapper.State.NODE_RESPONSE_ERROR);
                    request.getContext().handleProviderResponse(request);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void offerMessageToSend(ClassLoaderNioMessage message) throws Exception {
        this.sendQueue.offer(message);
        this.getServer().updateInterestOps(this.getSelectionKey(), 4, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(AsyncResourceRequest request) throws Exception {
        JPPFResourceWrapper resource = request.getResource();
        if (resource.isSingleResource()) {
            String uuid = (String)resource.getUuidPath().getFirst();
            byte[] content = this.getServer().getClassCache().getCacheContent(uuid, resource.getName());
            if (content != null) {
                if (debugEnabled) {
                    log.debug("resource [uuid={}, res={}] found in the cache, request will not be sent to the client", (Object)uuid, (Object)resource.getName());
                }
                resource.setDefinition(content);
                resource.setState(JPPFResourceWrapper.State.NODE_RESPONSE);
                request.getContext().handleProviderResponse(request);
                return;
            }
        }
        if (debugEnabled) {
            log.debug("adding request from node: {}'", (Object)resource);
        }
        CollectionMap<JPPFResourceWrapper, AsyncResourceRequest> collectionMap = this.requestMap;
        synchronized (collectionMap) {
            this.requestMap.putValue((Object)resource, (Object)request);
        }
        this.offerMessageToSend(this.serializeResource(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbPendingRequests() {
        CollectionMap<JPPFResourceWrapper, AsyncResourceRequest> collectionMap = this.requestMap;
        synchronized (collectionMap) {
            return this.requestMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncResourceRequest> getRequests(JPPFResourceWrapper resource) {
        CollectionMap<JPPFResourceWrapper, AsyncResourceRequest> collectionMap = this.requestMap;
        synchronized (collectionMap) {
            return new ArrayList<AsyncResourceRequest>(this.requestMap.getValues((Object)resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResourceRequest removeRequest(JPPFResourceWrapper resource) {
        long id = resource.getResourceId(this.driver.getUuid());
        if (debugEnabled) {
            log.debug("removing request with resource={}, resourceId={}", (Object)resource, (Object)id);
        }
        AsyncResourceRequest toRemove = null;
        CollectionMap<JPPFResourceWrapper, AsyncResourceRequest> collectionMap = this.requestMap;
        synchronized (collectionMap) {
            Collection requests = this.requestMap.getValues((Object)resource);
            if (requests != null) {
                for (AsyncResourceRequest request : requests) {
                    if (request.getResource().getResourceId(this.driver.getUuid()) != id) continue;
                    toRemove = request;
                    break;
                }
            }
            if (toRemove != null) {
                this.requestMap.removeValue((Object)resource, toRemove);
            }
        }
        return toRemove;
    }

    AtomicBoolean getClosed() {
        return this.closed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", connectionUuid=").append(this.connectionUuid);
        sb.append(", peer=").append(this.peer);
        sb.append(", ssl=").append(this.ssl);
        sb.append(", requests=").append(this.getNbPendingRequests());
        sb.append(", sendQueue size=").append(this.sendQueue.size());
        sb.append(", interestOps=").append(this.getInterestOps());
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean isProvider() {
        return true;
    }

    public AsyncClientClassNioServer getServer() {
        return (AsyncClientClassNioServer)super.getServer();
    }
}

