/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.client;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.classloader.AsyncResourceRequest;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientClassMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientClassMessageHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final JPPFDriver driver;
    private final AsyncClientClassNioServer server;

    public AsyncClientClassMessageHandler(AsyncClientClassNioServer server) {
        this.server = server;
        this.driver = server.getDriver();
    }

    void peerHandshakeResponse(AsyncClientClassContext context, JPPFResourceWrapper resource) throws Exception {
        String uuid = resource.getProviderUuid();
        context.setPeer(true);
        context.setUuid(uuid);
        if (debugEnabled) {
            log.debug("read initial response from peer {}, providerUuid={}", (Object)context, (Object)uuid);
        }
        this.server.addProviderConnection(uuid, context);
    }

    void providerHandshakeRequest(AsyncClientClassContext context, JPPFResourceWrapper resource) throws Exception {
        if (debugEnabled) {
            log.debug("read initial request from provider {}", (Object)context);
        }
        String uuid = (String)resource.getUuidPath().getFirst();
        if (debugEnabled) {
            log.debug("initializing provider with uuid={}", (Object)uuid);
        }
        context.setUuid(uuid);
        context.setConnectionUuid((String)resource.getData(ResourceIdentifier.CONNECTION_UUID));
        this.server.addProviderConnection(uuid, context);
        context.offerMessageToSend(context.serializeResource(resource));
        if (debugEnabled) {
            log.debug("initialized provider {}", (Object)context);
        }
    }

    void providerResponse(AsyncClientClassContext context, JPPFResourceWrapper resource) throws Exception {
        AsyncResourceRequest request = context.removeRequest(resource);
        if (debugEnabled) {
            log.debug("read response from provider {}, sending to node {}, resource = {}", new Object[]{context, request.getContext(), resource.getName()});
        }
        double elapsed = (double)(System.nanoTime() - request.getRequestStartTime()) / 1000000.0;
        if (resource.getDefinition() != null && resource.isSingleResource()) {
            this.server.getClassCache().setCacheContent((String)resource.getUuidPath().getFirst(), resource.getName(), resource.getDefinition());
        }
        resource.setState(JPPFResourceWrapper.State.NODE_RESPONSE);
        request.setResource(resource);
        request.getContext().handleProviderResponse(request);
        this.driver.getStatistics().addValue("client.class.requests.time", elapsed);
    }
}

