/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.client;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageReader;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassMessageHandler;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientClassMessageReader
extends NioMessageReader<AsyncClientClassContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientClassMessageReader.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncClientClassMessageReader(AsyncClientClassNioServer server) {
        super((StatelessNioServer)server);
    }

    protected NioMessageReader.MessageHandler<AsyncClientClassContext> createMessageHandler() {
        return AsyncClientClassMessageReader::handleMessage;
    }

    private static void handleMessage(AsyncClientClassContext context, NioMessage message) throws Exception {
        if (debugEnabled) {
            log.debug("read message = {} from context = {}", (Object)message, (Object)context);
        }
        ClassLoaderNioMessage msg = (ClassLoaderNioMessage)message;
        JPPFResourceWrapper resource = context.deserializeResource(msg);
        JPPFResourceWrapper.State state = resource.getState();
        AsyncClientClassMessageHandler handler = context.getServer().getMessageHandler();
        boolean peer = (Boolean)resource.getData(ResourceIdentifier.PEER, (Object)Boolean.FALSE);
        if (debugEnabled) {
            log.debug("read resource {} with PEER={}, from client {}", new Object[]{resource, peer, context});
        }
        if (peer && state == JPPFResourceWrapper.State.NODE_INITIATION) {
            handler.peerHandshakeResponse(context, resource);
        } else {
            switch (state) {
                case PROVIDER_INITIATION: {
                    handler.providerHandshakeRequest(context, resource);
                    break;
                }
                case PROVIDER_RESPONSE: 
                case NODE_RESPONSE: {
                    handler.providerResponse(context, resource);
                }
            }
        }
    }
}

