/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.client;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageWriter;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientClassMessageWriter
extends NioMessageWriter<AsyncClientClassContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientClassMessageWriter.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncClientClassMessageWriter(StatelessNioServer<AsyncClientClassContext> server) {
        super(server);
    }

    protected void postWrite(AsyncClientClassContext context, NioMessage data) throws Exception {
        if (debugEnabled) {
            ClassLoaderNioMessage msg = (ClassLoaderNioMessage)data;
            JPPFResourceWrapper resource = msg.getResource();
            log.debug("fully sent message {} for resource {} from {}", new Object[]{data, resource, context});
        }
    }
}

