/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.client;

import java.io.EOFException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jppf.nio.NioChannelHandler;
import org.jppf.nio.SSLHandler;
import org.jppf.nio.SSLHandlerImpl;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.classloader.ClassCache;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassMessageHandler;
import org.jppf.server.nio.classloader.client.AsyncClientClassMessageReader;
import org.jppf.server.nio.classloader.client.AsyncClientClassMessageWriter;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.VectorHashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncClientClassNioServer
extends StatelessNioServer<AsyncClientClassContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientClassNioServer.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final AsyncClientClassMessageHandler messageHandler;
    private final JPPFDriver driver;
    private final CollectionMap<String, AsyncClientClassContext> providerConnections = new VectorHashtable();
    final ClassCache classCache;

    public AsyncClientClassNioServer(JPPFDriver driver, int identifier, boolean useSSL) throws Exception {
        super(identifier, useSSL, driver.getConfiguration());
        this.driver = driver;
        this.selectTimeout = 1000L;
        this.messageHandler = new AsyncClientClassMessageHandler(this);
        this.classCache = driver.getInitializer().getClassCache();
    }

    protected void initReaderAndWriter() {
        this.messageReader = new AsyncClientClassMessageReader(this);
        this.messageWriter = new AsyncClientClassMessageWriter(this);
    }

    protected void handleSelectionException(SelectionKey key, Exception e) {
        AsyncClientClassContext context = (AsyncClientClassContext)((Object)key.attachment());
        if (e instanceof CancelledKeyException) {
            if (context != null && !context.isClosed()) {
                log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                this.closeConnection(context);
            }
        } else if (e instanceof EOFException) {
            if (debugEnabled) {
                log.debug("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            context.handleException(e);
        } else {
            log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            if (context != null) {
                context.handleException(e);
            }
        }
    }

    public void accept(ServerSocketChannel serverSocketChannel, SocketChannel channel, SSLHandler sslHandler, boolean ssl, boolean peer, Object ... params) {
        try {
            if (debugEnabled) {
                log.debug("accepting socketChannel = {}", (Object)channel);
            }
            AsyncClientClassContext context = this.createContext(channel, ssl);
            context.setPeer(peer);
            this.registerChannel((NioChannelHandler)context, channel);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private AsyncClientClassContext createContext(SocketChannel channel, boolean ssl) throws Exception {
        AsyncClientClassContext context = this.createNioContext(channel);
        if (debugEnabled) {
            log.debug("creating context for channel={}, ssl={}: {}", new Object[]{channel, ssl, context});
        }
        context.setSsl(ssl);
        if (ssl) {
            if (debugEnabled) {
                log.debug("creating SSLEngine for {}", (Object)context);
            }
            AsyncClientClassNioServer.configureSSL(context);
        }
        return context;
    }

    private static void configureSSL(AsyncClientClassContext context) throws Exception {
        if (debugEnabled) {
            log.debug("configuring SSL for {}", (Object)context);
        }
        SocketChannel channel = context.getSocketChannel();
        SSLContext sslContext = SSLHelper.getSSLContext((int)65531);
        InetSocketAddress addr = (InetSocketAddress)channel.getRemoteAddress();
        SSLEngine engine = sslContext.createSSLEngine(addr.getHostString(), addr.getPort());
        SSLParameters params = SSLHelper.getSSLParameters();
        engine.setUseClientMode(false);
        engine.setSSLParameters(params);
        if (debugEnabled) {
            log.debug("created SSLEngine: useClientMode = {}, parameters = {}", (Object)engine.getUseClientMode(), (Object)engine.getSSLParameters());
        }
        SSLHandlerImpl sslHandler = new SSLHandlerImpl(channel, engine);
        context.setSSLHandler((SSLHandler)sslHandler);
    }

    public AsyncClientClassContext createNioContext(Object ... params) {
        return new AsyncClientClassContext(this, (SocketChannel)params[0]);
    }

    public void closeConnection(AsyncClientClassContext channel) {
        this.closeConnection(channel, true);
    }

    public void closeConnection(AsyncClientClassContext context, boolean removeJobConnection) {
        String uuid;
        if (context == null) {
            log.warn("attempt to close null channel - skipping this step");
            return;
        }
        if (debugEnabled) {
            log.debug("closing {}", (Object)context);
        }
        if ((uuid = context.getUuid()) != null) {
            this.removeProviderConnection(uuid, context);
        } else if (debugEnabled) {
            log.debug("null uuid for {}", (Object)context);
        }
        if (removeJobConnection) {
            String connectionUuid = context.getConnectionUuid();
            AsyncClientNioServer clientJobServer = this.getDriver().getAsyncClientNioServer();
            clientJobServer.performContextAction(ctx -> connectionUuid != null && connectionUuid.equals(ctx.getConnectionUuid()), clientJobServer::closeConnection);
        }
    }

    public void addProviderConnection(String uuid, AsyncClientClassContext context) {
        if (debugEnabled) {
            log.debug("adding provider connection: uuid={}, context={}", (Object)uuid, (Object)context);
        }
        this.providerConnections.putValue((Object)uuid, (Object)context);
    }

    public void removeProviderConnection(String uuid, AsyncClientClassContext context) {
        if (debugEnabled) {
            log.debug("removing provider connection: uuid={}, context={}", (Object)uuid, (Object)context);
        }
        this.providerConnections.removeValue((Object)uuid, (Object)context);
    }

    public List<AsyncClientClassContext> getProviderConnections(String uuid) {
        Collection channels = this.providerConnections.getValues((Object)uuid);
        return channels == null ? null : new ArrayList(channels);
    }

    public void removeProviderConnections(String uuid) {
        Collection channels = this.providerConnections.removeKey((Object)uuid);
        if (channels != null) {
            for (AsyncClientClassContext channel : channels) {
                try {
                    this.closeConnection(channel);
                }
                catch (Exception e) {
                    log.error("error closing channel {} : {}", (Object)channel, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public List<AsyncClientClassContext> getAllProviderConnections() {
        List channels = this.providerConnections.allValues();
        return channels == null ? null : new ArrayList(channels);
    }

    public synchronized void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        List list = this.providerConnections.allValues();
        this.providerConnections.clear();
        super.removeAllConnections();
        if (list != null) {
            for (AsyncClientClassContext channel : list) {
                try {
                    this.closeConnection(channel);
                }
                catch (Exception e) {
                    log.error("error closing channel {} : {}", (Object)channel, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public AsyncClientClassMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    protected void initNioHandlers() {
        super.initNioHandlers();
        this.acceptHandler = null;
    }

    public JPPFDriver getDriver() {
        return this.driver;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }
}

