/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.node;

import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.classloader.AsyncLocalNodeClassloaderContext;
import org.jppf.classloader.CompositeResourceWrapper;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.server.nio.classloader.AbstractAsyncClassContext;
import org.jppf.server.nio.classloader.AsyncResourceRequest;
import org.jppf.server.nio.classloader.node.AsyncNodeClassMessageReader;
import org.jppf.server.nio.classloader.node.AsyncNodeClassMessageWriter;
import org.jppf.server.nio.classloader.node.AsyncNodeClassNioServer;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeClassContext
extends AbstractAsyncClassContext
implements AsyncLocalNodeClassloaderContext {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeClassContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final Map<Long, JPPFResourceWrapper> currentNodeRequests = new HashMap<Long, JPPFResourceWrapper>();
    private final CollectionMap<Long, AsyncResourceRequest> pendingResponses = new SetHashMap();
    private final Lock lockResponse = new ReentrantLock();
    private JPPFResourceWrapper localResponse;
    private final Lock localLock = new ReentrantLock();
    private final Condition responseSent = this.localLock.newCondition();

    public AsyncNodeClassContext(AsyncNodeClassNioServer server, SocketChannel socketChannel) {
        super(server.getDriver(), server);
        this.socketChannel = socketChannel;
    }

    public void handleException(Exception e) {
        if (debugEnabled) {
            log.debug("excception on channel {} :\n{}", (Object)this, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        this.getServer().closeConnection(this);
    }

    @Override
    protected boolean isProvider() {
        return false;
    }

    void offerMessageToSend(ClassLoaderNioMessage message) throws Exception {
        this.sendQueue.offer(message);
        this.getServer().updateInterestOps(this.getSelectionKey(), 4, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNodeRequest(JPPFResourceWrapper resource) {
        this.lockResponse.lock();
        try {
            long id = resource.getResourceId(this.driver.getUuid());
            if (debugEnabled) {
                log.debug("adding node request for id={}, resource={} to {}", new Object[]{id, resource, this});
            }
            this.currentNodeRequests.put(id, resource);
        }
        finally {
            this.lockResponse.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNodeRequest(JPPFResourceWrapper resource) {
        this.lockResponse.lock();
        try {
            long id = resource.getResourceId(this.driver.getUuid());
            this.currentNodeRequests.remove(id);
        }
        finally {
            this.lockResponse.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResourceRequest addPendingResponse(JPPFResourceWrapper resource) {
        this.lockResponse.lock();
        try {
            AsyncResourceRequest request = new AsyncResourceRequest(this, resource);
            resource.setState(JPPFResourceWrapper.State.PROVIDER_REQUEST);
            long id = resource.getResourceId(this.driver.getUuid());
            if (debugEnabled) {
                log.debug("adding pending response for id={}, resource={} to {}", new Object[]{id, resource, this});
            }
            this.pendingResponses.putValue((Object)id, (Object)request);
            AsyncResourceRequest asyncResourceRequest = request;
            return asyncResourceRequest;
        }
        finally {
            this.lockResponse.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleProviderResponse(AsyncResourceRequest request) throws Exception {
        this.lockResponse.lock();
        try {
            JPPFResourceWrapper response = request.getResource();
            long id = response.getResourceId(this.driver.getUuid());
            JPPFResourceWrapper nodeRequest = this.currentNodeRequests.get(id);
            if (debugEnabled) {
                log.debug("handling provider response with id={}, nodeRquest={} for request={}", new Object[]{id, nodeRequest, request});
            }
            if (nodeRequest == null) {
                return;
            }
            if (nodeRequest instanceof CompositeResourceWrapper) {
                ((CompositeResourceWrapper)nodeRequest).addOrReplaceResource(response);
            }
            this.pendingResponses.removeValue((Object)id, (Object)request);
            if (!this.pendingResponses.containsKey((Object)id)) {
                this.currentNodeRequests.remove(id);
                if (nodeRequest instanceof CompositeResourceWrapper) {
                    this.sendResponse(nodeRequest);
                } else {
                    response.setRequestStartTime(nodeRequest.getRequestStartTime());
                    this.sendResponse(response);
                }
            }
        }
        finally {
            this.lockResponse.unlock();
        }
    }

    public void sendResponse(JPPFResourceWrapper response) throws Exception {
        if (response.getState() == JPPFResourceWrapper.State.NODE_REQUEST) {
            response.setState(JPPFResourceWrapper.State.NODE_RESPONSE);
        }
        if (this.local) {
            this.setLocalResponse(response);
            AsyncNodeClassMessageWriter.handleResponseSent(this, response);
        } else {
            ClassLoaderNioMessage message = this.serializeResource(response);
            this.offerMessageToSend(message);
        }
    }

    public int getNbPendingResponses() {
        this.lockResponse.lock();
        try {
            int n = this.pendingResponses.size();
            return n;
        }
        finally {
            this.lockResponse.unlock();
        }
    }

    void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.lockResponse.lock();
            try {
                this.pendingResponses.clear();
                this.currentNodeRequests.clear();
            }
            finally {
                this.lockResponse.unlock();
            }
            this.sendQueue.clear();
            if (this.local) {
                this.localLock.lock();
                try {
                    this.responseSent.signalAll();
                }
                finally {
                    this.localLock.unlock();
                }
            }
        }
    }

    public void setLocalRequest(JPPFResourceWrapper localRequest) throws Exception {
        this.localLock.lock();
        try {
            this.localResponse = null;
        }
        finally {
            this.localLock.unlock();
        }
        AsyncNodeClassMessageReader.handleResource(this, localRequest);
    }

    public JPPFResourceWrapper awaitLocalResponse() throws Exception {
        this.localLock.lock();
        try {
            while (this.localResponse == null && !this.closed.get()) {
                this.responseSent.await();
            }
            JPPFResourceWrapper jPPFResourceWrapper = this.localResponse;
            return jPPFResourceWrapper;
        }
        finally {
            this.localLock.unlock();
        }
    }

    public void setLocalResponse(JPPFResourceWrapper localResponse) throws Exception {
        this.localLock.lock();
        try {
            this.localResponse = localResponse;
            this.responseSent.signalAll();
        }
        finally {
            this.localLock.unlock();
        }
    }

    public AsyncNodeClassNioServer getServer() {
        return (AsyncNodeClassNioServer)super.getServer();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", peer=").append(this.peer);
        sb.append(", ssl=").append(this.ssl);
        if (this.lockResponse.tryLock()) {
            try {
                sb.append(", currentRequests=").append(this.currentNodeRequests.size());
                sb.append(", pendingResponses=").append(this.pendingResponses.size());
            }
            finally {
                this.lockResponse.unlock();
            }
        }
        sb.append(", sendQueueSize=").append(this.sendQueue.size());
        sb.append(", interestOps=").append(this.getInterestOps());
        sb.append(']');
        return sb.toString();
    }
}

