/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.node;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.classloader.CompositeResourceWrapper;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.classloader.AsyncResourceRequest;
import org.jppf.server.nio.classloader.ClassCache;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.classloader.node.AsyncNodeClassNioServer;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.utils.TraversalList;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeClassMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeClassMessageHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final JPPFDriver driver;
    private final boolean isFileLookup;
    private final AtomicLong callableSeq = new AtomicLong(0L);
    private final ClassCache classCache;
    private final AtomicLong resourceSequence = new AtomicLong(0L);

    public AsyncNodeClassMessageHandler(JPPFDriver driver) {
        this.driver = driver;
        this.classCache = driver.getInitializer().getClassCache();
        this.isFileLookup = (Boolean)driver.getConfiguration().get(JPPFProperties.CLASSLOADER_FILE_LOOKUP);
    }

    void handshakeRequest(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        if (debugEnabled) {
            log.debug("read initial request from node {}", (Object)context);
        }
        resource.setHandshaking(true);
        context.setPeer((Boolean)resource.getData(ResourceIdentifier.PEER, (Object)Boolean.FALSE));
        if (debugEnabled) {
            log.debug("initiating node {}", (Object)context);
        }
        String uuid = (String)resource.getData(ResourceIdentifier.NODE_UUID);
        if (debugEnabled) {
            log.debug("received node init request for uuid = {}", (Object)uuid);
        }
        if (uuid != null) {
            context.setUuid(uuid);
            context.getServer().addNodeConnection(uuid, context);
        }
        resource.setState(context.isPeer() ? JPPFResourceWrapper.State.NODE_INITIATION : JPPFResourceWrapper.State.NODE_RESPONSE);
        resource.setProviderUuid(this.driver.getUuid());
        if (debugEnabled) {
            log.debug("sending handshake response {} to {}, providerUuid={}", new Object[]{resource, context, resource.getProviderUuid()});
        }
        context.sendResponse(resource);
    }

    void closeChannelRequest(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        if (debugEnabled) {
            log.debug("processing channel close request for node {}", (Object)context);
        }
        context.getServer().closeConnection(context);
        if (context.isPeer()) {
            String uuid = (String)resource.getData(ResourceIdentifier.NODE_UUID);
            AsyncNodeContext ctx = this.driver.getAsyncNodeNioServer().getConnection(uuid);
            if (ctx != null) {
                ctx.handleException(null);
            }
        }
    }

    void nodeRequest(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        if (debugEnabled) {
            log.debug("read resource request {} from node: {}", (Object)resource, (Object)context);
        }
        resource.setRequestStartTime(System.nanoTime());
        long id = this.resourceSequence.incrementAndGet();
        String uuid = this.driver.getUuid();
        resource.setResourceId(uuid, id);
        if (resource instanceof CompositeResourceWrapper) {
            for (JPPFResourceWrapper res : resource.getResources()) {
                res.setResourceIds(resource.getResourceIds());
            }
        }
        boolean allDefinitionsFound = true;
        context.addNodeRequest(resource);
        for (JPPFResourceWrapper res : resource.getResources()) {
            boolean b = !res.isDynamic() || res.getRequestUuid() == null ? this.processNonDynamic(context, res) : this.processDynamic(context, resource, res);
            allDefinitionsFound &= b;
        }
        if (allDefinitionsFound) {
            if (!context.isLocal()) {
                context.removeNodeRequest(resource);
            }
            context.sendResponse(resource);
        }
        if (debugEnabled) {
            log.debug("pending responses {} for node: {}", (Object)context.getNbPendingResponses(), (Object)context);
        }
    }

    private boolean processNonDynamic(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        String uuid;
        byte[] b = null;
        String name = resource.getName();
        TraversalList uuidPath = resource.getUuidPath();
        AsyncNodeClassNioServer server = context.getServer();
        String string = uuid = uuidPath.size() > 0 ? (String)uuidPath.getCurrentElement() : null;
        if ((uuid == null || uuid.equals(this.driver.getUuid())) && resource.getCallable() == null) {
            boolean fileLookup = (Boolean)resource.getData(ResourceIdentifier.FILE_LOOKUP_ALLOWED, (Object)true) != false && this.isFileLookup;
            ClassLoader cl = this.getClass().getClassLoader();
            if (resource.getData(ResourceIdentifier.MULTIPLE) != null) {
                List list = server.getResourceProvider().getMultipleResourcesAsBytes(name, cl, fileLookup);
                if (debugEnabled) {
                    log.debug("multiple resources {}found [{}] in driver's classpath for node {}", new Object[]{list != null ? "" : "not ", name, context});
                }
                if (list != null) {
                    resource.setData(ResourceIdentifier.RESOURCE_LIST, (Object)list);
                }
            } else if (resource.getData(ResourceIdentifier.MULTIPLE_NAMES) != null) {
                String[] names = (String[])resource.getData(ResourceIdentifier.MULTIPLE_NAMES);
                Map map = server.getResourceProvider().getMultipleResourcesAsBytes(cl, fileLookup, names);
                resource.setData(ResourceIdentifier.RESOURCE_MAP, (Object)map);
            } else {
                boolean alreadyInCache;
                if (uuid == null && !resource.isDynamic()) {
                    uuid = this.driver.getUuid();
                }
                if (uuid != null) {
                    b = this.classCache.getCacheContent(uuid, name);
                }
                boolean bl = alreadyInCache = b != null;
                if (debugEnabled) {
                    log.debug("resource {}found [{}] in cache for node {}", new Object[]{alreadyInCache ? "" : "not ", name, context});
                }
                if (!alreadyInCache) {
                    b = server.getResourceProvider().getResource(name, cl, fileLookup);
                    if (debugEnabled) {
                        log.debug("resource {}found [{}] in the driver's classpath for node {}", new Object[]{b == null ? "not " : "", name, context});
                    }
                }
                if (b != null || !resource.isDynamic()) {
                    if (b != null && !alreadyInCache) {
                        this.classCache.setCacheContent(this.driver.getUuid(), name, b);
                    }
                    resource.setDefinition(b);
                }
            }
        }
        resource.setState(JPPFResourceWrapper.State.NODE_RESPONSE);
        return true;
    }

    private boolean processDynamic(AsyncNodeClassContext context, JPPFResourceWrapper nodeRequest, JPPFResourceWrapper resource) throws Exception {
        byte[] b = null;
        String name = resource.getName();
        TraversalList uuidPath = resource.getUuidPath();
        if (resource.isSingleResource()) {
            b = this.classCache.getCacheContent((String)uuidPath.getFirst(), name);
            if (b != null) {
                resource.setDefinition(b);
                resource.setState(JPPFResourceWrapper.State.NODE_RESPONSE);
                return true;
            }
        } else if (resource.getCallable() != null) {
            resource.setData(ResourceIdentifier.DRIVER_CALLABLE_ID, (Object)this.callableSeq.incrementAndGet());
        }
        uuidPath.decPosition();
        String uuid = (String)resource.getUuidPath().getCurrentElement();
        AsyncClientClassContext provider = this.findProviderConnection(uuid);
        if (provider != null) {
            if (debugEnabled) {
                log.debug("requesting resource {} from client {} for node {}", new Object[]{resource, provider, context});
            }
            AsyncResourceRequest request = context.addPendingResponse(resource);
            provider.addRequest(request);
            return false;
        }
        if (debugEnabled) {
            log.debug("no available provider for uuid={} : setting null response for node {}", (Object)uuid, (Object)context);
        }
        resource.setDefinition(null);
        resource.setState(JPPFResourceWrapper.State.NODE_RESPONSE);
        return true;
    }

    private AsyncClientClassContext findProviderConnection(String uuid) throws Exception {
        AsyncClientClassContext result = null;
        AsyncClientClassNioServer clientClassServer = this.driver.getAsyncClientClassServer();
        List<AsyncClientClassContext> connections = clientClassServer.getProviderConnections(uuid);
        if (connections == null) {
            return null;
        }
        int minRequests = Integer.MAX_VALUE;
        for (AsyncClientClassContext channel : connections) {
            int size = channel.getNbPendingRequests();
            if (size >= minRequests) continue;
            minRequests = size;
            result = channel;
        }
        return result;
    }

    void responseSent(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        long elapsed = (System.nanoTime() - resource.getRequestStartTime()) / 1000000L;
        this.driver.getStatistics().addValues("node.class.requests.time", (double)elapsed, (long)resource.getResources().length);
        if (debugEnabled) {
            log.debug("node {} sent response {} ({} ms for {} requests)", new Object[]{context, resource, elapsed, resource.getResources().length});
        }
    }
}

