/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.node;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageReader;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.classloader.node.AsyncNodeClassMessageHandler;
import org.jppf.server.nio.classloader.node.AsyncNodeClassNioServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeClassMessageReader
extends NioMessageReader<AsyncNodeClassContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeClassMessageReader.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncNodeClassMessageReader(AsyncNodeClassNioServer server) {
        super((StatelessNioServer)server);
    }

    protected NioMessageReader.MessageHandler<AsyncNodeClassContext> createMessageHandler() {
        return AsyncNodeClassMessageReader::handleMessage;
    }

    private static void handleMessage(AsyncNodeClassContext context, NioMessage message) throws Exception {
        if (debugEnabled) {
            log.debug("read message = {} from context = {}", (Object)message, (Object)context);
        }
        ClassLoaderNioMessage msg = (ClassLoaderNioMessage)message;
        JPPFResourceWrapper resource = context.deserializeResource(msg);
        AsyncNodeClassMessageReader.handleResource(context, resource);
    }

    static void handleResource(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        if (debugEnabled) {
            log.debug("read resource {} from node {}", (Object)resource, (Object)context);
        }
        AsyncNodeClassMessageHandler handler = context.getServer().getMessageHandler();
        switch (resource.getState()) {
            case NODE_INITIATION: {
                handler.handshakeRequest(context, resource);
                break;
            }
            case PROVIDER_REQUEST: 
            case NODE_REQUEST: {
                handler.nodeRequest(context, resource);
                break;
            }
            case CLOSE_CHANNEL: {
                handler.closeChannelRequest(context, resource);
            }
        }
    }
}

