/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.node;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageWriter;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.classloader.node.AsyncNodeClassNioServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeClassMessageWriter
extends NioMessageWriter<AsyncNodeClassContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeClassMessageWriter.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncNodeClassMessageWriter(AsyncNodeClassNioServer server) {
        super((StatelessNioServer)server);
    }

    protected void postWrite(AsyncNodeClassContext context, NioMessage data) throws Exception {
        ClassLoaderNioMessage msg = (ClassLoaderNioMessage)data;
        JPPFResourceWrapper resource = msg.getResource();
        if (debugEnabled) {
            log.debug("fully sent message {} for resource = {} from context {}", new Object[]{data, resource, context});
        }
        AsyncNodeClassMessageWriter.handleResponseSent(context, resource);
    }

    static void handleResponseSent(AsyncNodeClassContext context, JPPFResourceWrapper resource) throws Exception {
        if (resource != null && !resource.isHandshaking() && resource.getState() == JPPFResourceWrapper.State.NODE_RESPONSE) {
            context.getServer().getMessageHandler().responseSent(context, resource);
        }
    }
}

