/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.classloader.node;

import java.io.EOFException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jppf.classloader.AsyncLocalNodeClassloaderContext;
import org.jppf.classloader.ResourceProvider;
import org.jppf.classloader.ResourceProviderImpl;
import org.jppf.nio.NioChannelHandler;
import org.jppf.nio.SSLHandler;
import org.jppf.nio.SSLHandlerImpl;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.classloader.node.AsyncNodeClassMessageHandler;
import org.jppf.server.nio.classloader.node.AsyncNodeClassMessageReader;
import org.jppf.server.nio.classloader.node.AsyncNodeClassMessageWriter;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncNodeClassNioServer
extends StatelessNioServer<AsyncNodeClassContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeClassNioServer.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final AsyncNodeClassMessageHandler messageHandler;
    private final JPPFDriver driver;
    protected final Map<String, AsyncNodeClassContext> nodeConnections = new ConcurrentHashMap<String, AsyncNodeClassContext>();
    private final ResourceProvider resourceProvider = new ResourceProviderImpl();

    public AsyncNodeClassNioServer(JPPFDriver driver, int identifier, boolean useSSL) throws Exception {
        super(identifier, useSSL, driver.getConfiguration());
        this.driver = driver;
        this.selectTimeout = 1000L;
        this.messageHandler = new AsyncNodeClassMessageHandler(driver);
    }

    protected void initReaderAndWriter() {
        this.messageReader = new AsyncNodeClassMessageReader(this);
        this.messageWriter = new AsyncNodeClassMessageWriter(this);
    }

    protected void handleSelectionException(SelectionKey key, Exception e) {
        AsyncNodeClassContext context = (AsyncNodeClassContext)((Object)key.attachment());
        if (e instanceof CancelledKeyException) {
            if (context != null && !context.isClosed()) {
                log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                this.closeConnection(context);
            }
        } else if (e instanceof EOFException) {
            if (debugEnabled) {
                log.debug("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            context.handleException(e);
        } else {
            log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            if (context != null) {
                context.handleException(e);
            }
        }
    }

    public void accept(ServerSocketChannel serverSocketChannel, SocketChannel channel, SSLHandler sslHandler, boolean ssl, boolean peer, Object ... params) {
        try {
            if (debugEnabled) {
                log.debug("accepting socketChannel = {}", (Object)channel);
            }
            AsyncNodeClassContext context = this.createContext(channel, ssl);
            context.setPeer(peer);
            this.registerChannel((NioChannelHandler)context, channel);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private AsyncNodeClassContext createContext(SocketChannel channel, boolean ssl) throws Exception {
        AsyncNodeClassContext context = this.createNioContext(channel);
        if (debugEnabled) {
            log.debug("creating context for channel={}, ssl={}: {}", new Object[]{channel, ssl, context});
        }
        context.setSsl(ssl);
        if (ssl) {
            if (debugEnabled) {
                log.debug("creating SSLEngine for {}", (Object)context);
            }
            AsyncNodeClassNioServer.configureSSL(context);
        }
        return context;
    }

    private static void configureSSL(AsyncNodeClassContext context) throws Exception {
        if (debugEnabled) {
            log.debug("configuring SSL for {}", (Object)context);
        }
        SocketChannel channel = context.getSocketChannel();
        SSLContext sslContext = SSLHelper.getSSLContext((int)65533);
        InetSocketAddress addr = (InetSocketAddress)channel.getRemoteAddress();
        SSLEngine engine = sslContext.createSSLEngine(addr.getHostString(), addr.getPort());
        SSLParameters params = SSLHelper.getSSLParameters();
        engine.setUseClientMode(false);
        engine.setSSLParameters(params);
        if (debugEnabled) {
            log.debug("created SSLEngine: useClientMode = {}, parameters = {}", (Object)engine.getUseClientMode(), (Object)engine.getSSLParameters());
        }
        SSLHandlerImpl sslHandler = new SSLHandlerImpl(channel, engine);
        context.setSSLHandler((SSLHandler)sslHandler);
    }

    public AsyncNodeClassContext createNioContext(Object ... params) {
        return new AsyncNodeClassContext(this, (SocketChannel)params[0]);
    }

    public void closeConnection(AsyncNodeClassContext context) {
        block12: {
            if (debugEnabled) {
                log.debug("closing {}", (Object)context);
            }
            try {
                String uuid;
                SelectionKey key = context.getSelectionKey();
                if (key != null) {
                    key.cancel();
                    key.channel().close();
                }
                if ((uuid = context.getUuid()) != null) {
                    this.removeNodeConnection(uuid);
                }
                try {
                    context.close();
                }
                catch (Exception e) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    log.warn(e.getMessage());
                }
                if (!context.isPeer()) break block12;
                try {
                    AsyncNodeContext ctx = this.getDriver().getAsyncNodeNioServer().getConnection(uuid);
                    if (ctx != null) {
                        ctx.handleException(null);
                    }
                }
                catch (Exception e) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                        break block12;
                    }
                    log.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("error closing channel {}: {}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public AsyncNodeClassContext getNodeConnection(String uuid) {
        return this.nodeConnections.get(uuid);
    }

    public void addNodeConnection(String uuid, AsyncNodeClassContext channel) {
        if (debugEnabled) {
            log.debug("adding node connection: uuid=" + uuid + ", channel=" + (Object)((Object)channel));
        }
        this.nodeConnections.put(uuid, channel);
    }

    public AsyncLocalNodeClassloaderContext removeNodeConnection(String uuid) {
        if (debugEnabled) {
            log.debug("removing node connection: uuid=" + uuid);
        }
        return this.nodeConnections.remove(uuid);
    }

    public void connectionFailed(AsyncNodeClassContext channel) {
        if (channel != null) {
            if (debugEnabled) {
                log.debug("about to close channel = {} with uuid = {}", (Object)channel, (Object)channel.getUuid());
            }
            this.closeConnection(channel);
        }
    }

    public synchronized void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        ArrayList<AsyncNodeClassContext> list = new ArrayList<AsyncNodeClassContext>(this.nodeConnections.values());
        this.nodeConnections.clear();
        super.removeAllConnections();
        for (AsyncNodeClassContext channel : list) {
            try {
                this.closeConnection(channel);
            }
            catch (Exception e) {
                log.error("error closing channel {} : {}", (Object)channel, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public List<AsyncNodeClassContext> getAllNodeConnections() {
        ArrayList<AsyncNodeClassContext> list = new ArrayList<AsyncNodeClassContext>(this.nodeConnections.values());
        return list;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public AsyncNodeClassMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    protected void initNioHandlers() {
        super.initNioHandlers();
        this.acceptHandler = null;
    }

    JPPFDriver getDriver() {
        return this.driver;
    }
}

