/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.nio.AbstractNioContext;
import org.jppf.nio.NioContext;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.protocol.graph.TaskGraphInfo;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.client.ClientMessage;
import org.jppf.server.nio.client.JobEntry;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.utils.ComparisonOperator;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.Operator;
import org.jppf.utils.concurrent.SynchronizedLong;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientContext
extends AbstractNioContext {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final JobEntryDebugStats entryStats = new JobEntryDebugStats();
    final JPPFDriver driver;
    final AsyncClientNioServer server;
    private final Map<String, JobEntry> entryMap = new ConcurrentHashMap<String, JobEntry>();
    private final BlockingQueue<ClientMessage> sendQueue = new LinkedBlockingQueue<ClientMessage>();
    private final boolean jppfDebugEnabled;

    AsyncClientContext(AsyncClientNioServer server, SocketChannel socketChannel) {
        this.server = server;
        this.driver = server.getDriver();
        this.socketChannel = socketChannel;
        this.jppfDebugEnabled = this.driver.isJppfDebugEnabled();
    }

    public void handleException(Exception e) {
        if (this.getClosed().compareAndSet(false, true)) {
            if (debugEnabled) {
                log.debug("handling exception on {}:{}", (Object)this, (Object)(e == null ? " null" : "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
            }
            this.cancelJobsOnClose();
            this.server.closeConnection(this);
            this.onClose();
        }
    }

    public ClientMessage serializeBundle(ServerTaskBundleClient bundle) throws Exception {
        List<ServerTask> tasks;
        ClientMessage message = this.newMessage(bundle);
        TaskBundle header = bundle.getJob();
        header.setSLA(null);
        header.setMetadata(null);
        List<ServerTask> list = tasks = header.isHandshake() ? null : bundle.getTaskList();
        if (!header.isHandshake()) {
            int[] positions = new int[tasks.size()];
            for (int i = 0; i < tasks.size(); ++i) {
                positions[i] = tasks.get(i).getPosition();
            }
            header.setParameter((Object)BundleParameter.TASK_POSITIONS, (Object)positions);
            header.removeParameter((Object)BundleParameter.TASK_MAX_RESUBMITS);
        }
        message.addLocation(IOHelper.serializeData((Object)header, (ObjectSerializer)this.driver.getSerializer()));
        if (tasks != null) {
            for (ServerTask task : tasks) {
                message.addLocation(task.getResult());
            }
        }
        message.setBundle(header);
        return message;
    }

    public ServerTaskBundleClient deserializeBundle(ClientMessage message) throws Exception {
        int dependencyCount;
        List locations = message.getLocations();
        TaskBundle bundle = message.getBundle();
        if (locations.size() <= 2) {
            return new ServerTaskBundleClient(bundle, (DataLocation)locations.get(1), Collections.emptyList(), false);
        }
        ServerTaskBundleClient clientBundle = new ServerTaskBundleClient(bundle, (DataLocation)locations.get(1), locations.subList(2, 2 + bundle.getTaskCount()), this.isPeer());
        TaskGraphInfo graphInfo = (TaskGraphInfo)bundle.getParameter((Object)BundleParameter.JOB_TASK_GRAPH_INFO, null);
        int n = dependencyCount = graphInfo == null ? 0 : graphInfo.getNbDependencies();
        if (dependencyCount > 0) {
            if (debugEnabled) {
                log.debug("there are {} dependencies for {}", (Object)dependencyCount, (Object)this);
            }
            clientBundle.setDependencies(locations.subList(2 + bundle.getTaskCount(), locations.size()), graphInfo);
        }
        return clientBundle;
    }

    public ClientMessage newMessage(ServerTaskBundleClient clientBundle) {
        return new ClientMessage((NioContext)this, clientBundle);
    }

    public boolean readMessage() throws Exception {
        if (this.readMessage == null) {
            this.readMessage = this.newMessage(null);
        }
        this.readByteCount = this.readMessage.getChannelReadCount();
        boolean b = false;
        try {
            b = this.readMessage.read();
        }
        catch (Exception e) {
            this.updateTrafficStats((ClientMessage)this.readMessage);
            throw e;
        }
        this.readByteCount = this.readMessage.getChannelReadCount() - this.readByteCount;
        if (b) {
            this.updateTrafficStats((ClientMessage)this.readMessage);
        }
        return b;
    }

    public boolean writeMessage() throws Exception {
        this.writeByteCount = this.writeMessage.getChannelWriteCount();
        boolean b = false;
        try {
            b = this.writeMessage.write();
        }
        catch (Exception e) {
            this.updateTrafficStats((ClientMessage)this.writeMessage);
            throw e;
        }
        this.writeByteCount = this.writeMessage.getChannelWriteCount() - this.writeByteCount;
        if (b) {
            this.updateTrafficStats((ClientMessage)this.writeMessage);
        }
        return b;
    }

    public JobEntry getJobEntry(String jobUuid, long bundleId) {
        return this.entryMap.get(jobUuid + bundleId);
    }

    public void addEntry(ServerTaskBundleClient bundle) {
        String id = bundle.getUuid() + bundle.getId();
        if (debugEnabled) {
            log.debug("adding job entry [jobUuid={}, bundleId={}]", (Object)bundle.getUuid(), (Object)bundle.getId());
        }
        this.entryMap.put(id, new JobEntry(bundle));
        if (this.jppfDebugEnabled) {
            entryStats.add();
        }
    }

    public JobEntry removeJobEntry(String jobUuid, long bundleId) {
        if (traceEnabled) {
            log.trace("removing job entry with jobUuid={}, bundleId={}, call stack:\n{}", new Object[]{jobUuid, bundleId, ExceptionUtils.getCallStack()});
        } else if (debugEnabled) {
            log.debug("removing job entry with jobUuid={}, bundleId={}", (Object)jobUuid, (Object)bundleId);
        }
        JobEntry entry = this.entryMap.remove(jobUuid + bundleId);
        if (this.jppfDebugEnabled) {
            if (entry == null) {
                entryStats.notFound();
                log.warn("job entry not found [jobUuid={}, bundleId={}] in {}\ncall stack:\n{}", new Object[]{jobUuid, bundleId, this, ExceptionUtils.getCallStack()});
            }
            entryStats.remove();
        }
        return entry;
    }

    void cancelJobsOnClose() {
        ArrayList entriesToRemove = new ArrayList(this.entryMap.size());
        this.entryMap.forEach((id, entry) -> {
            ServerTaskBundleClient bundle;
            this.cancelJobOnClose((JobEntry)entry);
            if (entry != null && (bundle = entry.getBundle()) != null && bundle.getSLA().isCancelUponClientDisconnect()) {
                entriesToRemove.add(id);
            }
        });
        entriesToRemove.forEach(id -> this.entryMap.remove(id));
    }

    void cancelJobOnClose(JobEntry jobEntry) {
        String jobUuid = jobEntry.jobUuid;
        int tasksToSend = jobEntry.nbTasksToSend;
        ServerTaskBundleClient clientBundle = jobEntry.getBundle();
        if (clientBundle != null) {
            TaskBundle header = clientBundle.getJob();
            if (debugEnabled) {
                log.debug("cancelUponClientDisconnect={} for {}", (Object)header.getSLA().isCancelUponClientDisconnect(), (Object)header);
            }
            if (header.getSLA().isCancelUponClientDisconnect()) {
                try {
                    ServerJob job = this.driver.getQueue().getJob(clientBundle.getUuid());
                    int taskCount = 0;
                    if (job != null) {
                        taskCount = job.getTaskCount();
                        if (debugEnabled) {
                            log.debug("cancelling job {}", (Object)job);
                        }
                        job.cancel(this.driver, true);
                    }
                    int tasksToSend2 = jobEntry.nbTasksToSend;
                    int n = tasksToSend - tasksToSend2 - taskCount;
                    if (debugEnabled) {
                        log.debug("tasksToSend={}, tasksToSend2={}, n={}, taskCount={}, serverJob={}", new Object[]{tasksToSend, tasksToSend2, n, taskCount, job});
                    }
                    JPPFStatistics stats = this.driver.getStatistics();
                    stats.addValue("task.queue.count", (double)(-taskCount));
                    if (job != null) {
                        this.driver.getQueue().removeBundle(job);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        } else if (jobUuid != null) {
            ServerJob job = this.driver.getQueue().getJob(jobUuid);
            if (job == null) {
                job = this.driver.getQueue().getJobFromPriorityMap(jobUuid);
            }
            if (debugEnabled) {
                log.debug("case 2: removing {}, jobUuid={}", (Object)job, (Object)jobUuid);
            }
            if (job != null && job.getSLA().isCancelUponClientDisconnect()) {
                this.driver.getQueue().removeBundle(job);
            }
        }
    }

    private void updateTrafficStats(ClientMessage message) {
        if (message != null) {
            double value;
            if (this.inSnapshot == null) {
                this.inSnapshot = this.driver.getStatistics().getSnapshot(this.peer ? "peer.traffic.in" : "client.traffic.in");
            }
            if (this.outSnapshot == null) {
                this.outSnapshot = this.driver.getStatistics().getSnapshot(this.peer ? "peer.traffic.out" : "client.traffic.out");
            }
            if ((value = (double)message.getChannelReadCount()) > 0.0) {
                this.inSnapshot.addValues(value, 1L);
            }
            if ((value = (double)message.getChannelWriteCount()) > 0.0) {
                this.outSnapshot.addValues(value, 1L);
            }
        }
    }

    AtomicBoolean getClosed() {
        return this.closed;
    }

    void offerMessageToSend(ServerTaskBundleClient bundle, ClientMessage message) throws Exception {
        this.sendQueue.offer(message);
        this.server.updateInterestOps(this.getSelectionKey(), 4, true);
    }

    protected ClientMessage nextMessageToSend() {
        return (ClientMessage)((Object)this.sendQueue.poll());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", connectionUuid=").append(this.connectionUuid);
        sb.append(", peer=").append(this.peer);
        sb.append(", ssl=").append(this.ssl);
        sb.append(", jobEntries=").append(this.entryMap.size());
        sb.append(", sendQueue size=").append(this.sendQueue.size());
        sb.append(", interestOps=").append(this.getInterestOps());
        sb.append(", socketChannel=").append(this.socketChannel);
        sb.append(']');
        return sb.toString();
    }

    public static JobEntryDebugStats getEntrystats() {
        return entryStats;
    }

    public Map<String, JobEntry> getEntryMap() {
        return this.entryMap;
    }

    public static class JobEntryDebugStats {
        final AtomicLong totalCurrent = new AtomicLong(0L);
        final AtomicLong totalAdded = new AtomicLong(0L);
        final AtomicLong totalRemoved = new AtomicLong(0L);
        final SynchronizedLong peak = new SynchronizedLong(0L);
        final AtomicLong totalNotFound = new AtomicLong(0L);

        public void add() {
            long n = this.totalCurrent.incrementAndGet();
            this.peak.compareAndSet((ComparisonOperator)Operator.LESS_THAN, n);
            this.totalAdded.incrementAndGet();
        }

        public void remove() {
            this.totalCurrent.decrementAndGet();
            this.totalRemoved.incrementAndGet();
        }

        public void notFound() {
            this.totalNotFound.incrementAndGet();
        }

        public String toString() {
            return this.getClass().getSimpleName() + '[' + "current: " + this.totalCurrent.get() + ", peak: " + this.peak.get() + ", added: " + this.totalAdded.get() + ", removed: " + this.totalRemoved.get() + ", notFound: " + this.totalNotFound.get() + ']';
        }
    }
}

