/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageReader;
import org.jppf.nio.StatelessNioServer;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.nio.client.AsyncClientContext;
import org.jppf.server.nio.client.AsyncClientMessageHandler;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.client.ClientMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientMessageReader
extends NioMessageReader<AsyncClientContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientMessageReader.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncClientMessageReader(AsyncClientNioServer server) {
        super((StatelessNioServer)server);
    }

    protected NioMessageReader.MessageHandler<AsyncClientContext> createMessageHandler() {
        return AsyncClientMessageReader::handleMessage;
    }

    private static void handleMessage(AsyncClientContext context, NioMessage message) throws Exception {
        if (debugEnabled) {
            log.debug("read message = {} from context = {}", (Object)message, (Object)context);
        }
        ClientMessage msg = (ClientMessage)message;
        TaskBundle header = msg.getBundle();
        AsyncClientMessageHandler handler = context.server.getMessageHandler();
        if (debugEnabled) {
            log.debug("read bundle {} from client {}", (Object)header, (Object)context);
        }
        if (header.isHandshake()) {
            if (context.isPeer()) {
                handler.peerHandshakeResponseReceived(context, msg);
            } else {
                handler.handshakeReceived(context, msg);
            }
        } else {
            handler.jobReceived(context, msg);
        }
    }
}

