/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import org.jppf.nio.NioHelper;
import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageWriter;
import org.jppf.nio.StatelessNioServer;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.nio.client.AsyncClientContext;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.client.ClientMessage;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientMessageWriter
extends NioMessageWriter<AsyncClientContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientMessageWriter.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncClientMessageWriter(StatelessNioServer<AsyncClientContext> server) {
        super(server);
    }

    protected void postWrite(AsyncClientContext context, NioMessage data) throws Exception {
        ClientMessage msg = (ClientMessage)data;
        TaskBundle header = msg.getBundle();
        if (debugEnabled) {
            log.debug("fully sent message {} for job [uuid={}, name={}, handshake={}] from context {}", new Object[]{data, header.getUuid(), header.getName(), header.isHandshake(), context});
        }
        if (!header.isHandshake()) {
            ServerTaskBundleClient clientBundle = msg.getClientBundle();
            NioHelper.getGlobalexecutor().execute(() -> {
                try {
                    ((AsyncClientNioServer)this.server).getMessageHandler().jobResultsSent(context, clientBundle);
                }
                catch (Exception e) {
                    context.handleException(e);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            });
        }
    }
}

