/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import java.io.EOFException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jppf.nio.NioChannelHandler;
import org.jppf.nio.SSLHandler;
import org.jppf.nio.SSLHandlerImpl;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.jppf.server.nio.client.AsyncClientContext;
import org.jppf.server.nio.client.AsyncClientMessageHandler;
import org.jppf.server.nio.client.AsyncClientMessageReader;
import org.jppf.server.nio.client.AsyncClientMessageWriter;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncClientNioServer
extends StatelessNioServer<AsyncClientContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncClientNioServer.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private static final boolean traceEnabled = log.isTraceEnabled();
    private final AsyncClientMessageHandler messageHandler;
    private final JPPFDriver driver;

    public AsyncClientNioServer(JPPFDriver driver, int identifier, boolean useSSL) throws Exception {
        super(identifier, useSSL, driver.getConfiguration());
        this.driver = driver;
        this.selectTimeout = 1000L;
        this.messageHandler = new AsyncClientMessageHandler(driver);
    }

    protected void initReaderAndWriter() {
        this.messageReader = new AsyncClientMessageReader(this);
        this.messageWriter = new AsyncClientMessageWriter(this);
    }

    protected void go(Set<SelectionKey> selectedKeys) throws Exception {
        if (traceEnabled) {
            int writable = 0;
            int readable = 0;
            int invalid = 0;
            for (SelectionKey key : selectedKeys) {
                if (!key.isValid()) {
                    ++invalid;
                    continue;
                }
                if (key.isReadable()) {
                    ++readable;
                }
                if (!key.isWritable()) continue;
                ++writable;
            }
            log.trace("nb keys = {}, readable = {}, writable = {}, invalid = {}", new Object[]{selectedKeys.size(), readable, writable, invalid});
        }
        super.go(selectedKeys);
    }

    protected void handleSelectionException(SelectionKey key, Exception e) {
        AsyncClientContext context = (AsyncClientContext)((Object)key.attachment());
        if (e instanceof CancelledKeyException) {
            if (context != null && !context.isClosed()) {
                log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                this.closeConnection(context);
            }
        } else if (e instanceof EOFException) {
            if (debugEnabled) {
                log.debug("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            context.handleException(e);
        } else {
            log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            if (context != null) {
                context.handleException(e);
            }
        }
    }

    public void accept(ServerSocketChannel serverSocketChannel, SocketChannel channel, SSLHandler sslHandler, boolean ssl, boolean peer, Object ... params) {
        try {
            if (debugEnabled) {
                log.debug("accepting socketChannel = {}", (Object)channel);
            }
            AsyncClientContext context = this.createContext(channel, ssl);
            context.setPeer(peer);
            this.registerChannel((NioChannelHandler)context, channel);
            if (debugEnabled) {
                log.debug("registered channel = {}, for context = {}", (Object)channel, (Object)context);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.driver.getStatistics().addValue("clients", 1.0);
    }

    private AsyncClientContext createContext(SocketChannel channel, boolean ssl) throws Exception {
        AsyncClientContext context = this.createNioContext(channel);
        if (debugEnabled) {
            log.debug("creating context for channel={}, ssl={}: {}", new Object[]{channel, ssl, context});
        }
        context.setSsl(ssl);
        if (ssl) {
            if (debugEnabled) {
                log.debug("creating SSLEngine for {}", (Object)context);
            }
            AsyncClientNioServer.configureSSL(context);
        }
        return context;
    }

    private static void configureSSL(AsyncClientContext context) throws Exception {
        if (debugEnabled) {
            log.debug("configuring SSL for {}", (Object)context);
        }
        SocketChannel channel = context.getSocketChannel();
        SSLContext sslContext = SSLHelper.getSSLContext((int)65530);
        InetSocketAddress addr = (InetSocketAddress)channel.getRemoteAddress();
        SSLEngine engine = sslContext.createSSLEngine(addr.getHostString(), addr.getPort());
        SSLParameters params = SSLHelper.getSSLParameters();
        engine.setUseClientMode(false);
        engine.setSSLParameters(params);
        if (debugEnabled) {
            log.debug("created SSLEngine: useClientMode = {}, parameters = {}", (Object)engine.getUseClientMode(), (Object)engine.getSSLParameters());
        }
        SSLHandlerImpl sslHandler = new SSLHandlerImpl(channel, engine);
        context.setSSLHandler((SSLHandler)sslHandler);
    }

    public AsyncClientContext createNioContext(Object ... params) {
        return new AsyncClientContext(this, (SocketChannel)params[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(AsyncClientContext context) {
        if (debugEnabled) {
            log.debug("closing {}", (Object)context);
        }
        try {
            String uuid;
            SelectionKey key = context.getSelectionKey();
            if (key != null) {
                key.cancel();
                key.channel().close();
            }
            if ((uuid = context.getUuid()) != null) {
                this.handleClassLoaderAsync(context, uuid);
            }
        }
        catch (Exception e) {
            log.error("error closing channel {}", (Object)context, (Object)e);
        }
        finally {
            this.driver.getStatistics().addValue("clients", -1.0);
        }
    }

    private void handleClassLoaderAsync(AsyncClientContext context, String uuid) throws Exception {
        AsyncClientClassNioServer classServer = this.driver.getAsyncClientClassServer();
        List<AsyncClientClassContext> list = classServer.getProviderConnections(uuid);
        if (debugEnabled) {
            log.debug("found {} provider connections for clientUuid={}; context={}", new Object[]{list == null ? 0 : list.size(), uuid, context});
        }
        if (list != null && !list.isEmpty()) {
            for (AsyncClientClassContext ctx : list) {
                if (!ctx.getConnectionUuid().equals(context.getConnectionUuid())) continue;
                if (debugEnabled) {
                    log.debug("found provider connection with connectionUuid={} : {}", (Object)context.getConnectionUuid(), (Object)ctx);
                }
                try {
                    classServer.closeConnection(ctx, false);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
    }

    public void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        super.removeAllConnections();
    }

    public AsyncClientMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    protected void initNioHandlers() {
        super.initNioHandlers();
        this.acceptHandler = null;
    }

    JPPFDriver getDriver() {
        return this.driver;
    }
}

