/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.nio.NioContext;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.protocol.graph.TaskGraphInfo;
import org.jppf.server.nio.AbstractTaskBundleMessage;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMessage
extends AbstractTaskBundleMessage {
    private static final Logger log = LoggerFactory.getLogger(ClientMessage.class);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private final ServerTaskBundleClient clientBundle;

    public ClientMessage(NioContext context, ServerTaskBundleClient clientBundle) {
        super(context);
        this.clientBundle = clientBundle;
    }

    protected void afterFirstRead() throws Exception {
        this.bundle = (TaskBundle)IOHelper.unwrappedData((DataLocation)((DataLocation)this.locations.get(0)));
        TaskGraphInfo graphInfo = (TaskGraphInfo)this.bundle.getParameter((Object)BundleParameter.JOB_TASK_GRAPH_INFO, null);
        int dependencyCount = graphInfo == null ? 0 : graphInfo.getNbDependencies();
        this.nbObjects = this.bundle.getTaskCount() + 2 + dependencyCount;
        if (traceEnabled) {
            log.trace("read task bundle with {} dependencies : {}, context = {}", new Object[]{dependencyCount, this.bundle, this.channel});
        }
    }

    protected void beforeFirstWrite() throws Exception {
        this.nbObjects = this.bundle.getTaskCount() + 1;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '[' + "nb locations=" + (this.locations == null ? -1 : this.locations.size()) + ", position=" + this.position + ", nbObjects=" + this.nbObjects + ", count=" + this.count + ", currentLength=" + this.currentLength + ']';
    }

    public ServerTaskBundleClient getClientBundle() {
        return this.clientBundle;
    }

    protected boolean readNextObject() throws Exception {
        boolean result = super.readNextObject();
        if (traceEnabled && result) {
            log.trace("read next object of {}, context = {}", (Object)this, (Object)this.channel);
        }
        return result;
    }
}

