/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import java.nio.channels.SelectionKey;
import java.util.List;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.nio.client.AsyncClientContext;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionListener
implements ServerTaskBundleClient.CompletionListener {
    private static Logger log = LoggerFactory.getLogger(CompletionListener.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final AsyncClientContext context;

    public CompletionListener(AsyncClientContext context) {
        if (context == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.context = context;
    }

    @Override
    public void taskCompleted(ServerTaskBundleClient bundle, List<ServerTask> results) {
        if (bundle == null) {
            throw new IllegalStateException("bundler is null");
        }
        if (!this.isChannelValid()) {
            log.warn("attempt to send bundle to invalid channel {}\nbundle = {}", (Object)this.context, (Object)bundle);
            try {
                this.context.server.getMessageHandler().jobResultsSent(this.context, bundle);
            }
            catch (Exception e) {
                log.error("Error sending job results for {}:\n", (Object)bundle, (Object)e);
            }
            return;
        }
        if (results.isEmpty()) {
            if (debugEnabled) {
                log.debug("empty results list for bundle {}", (Object)bundle);
            }
            return;
        }
        if (debugEnabled) {
            log.debug("*** returning " + results.size() + " results for client bundle " + bundle + "(cancelled=" + bundle.isCancelled() + ')');
        }
        if (bundle.isCancelled()) {
            bundle.removeCompletionListener(this);
        } else {
            try {
                this.context.server.getMessageHandler().sendJobResults(this.context, bundle);
            }
            catch (Exception e) {
                log.error("Error sending job results for {}:\n", (Object)bundle, (Object)e);
            }
        }
    }

    @Override
    public void bundleEnded(ServerTaskBundleClient bundle) {
        if (debugEnabled) {
            log.debug("bundle ended: {}", (Object)bundle);
        }
    }

    private boolean isChannelValid() {
        return StatelessNioServer.isKeyValid((SelectionKey)this.context.getSelectionKey());
    }
}

