/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.client;

import org.jppf.server.protocol.ServerTaskBundleClient;

public class JobEntry {
    private final ServerTaskBundleClient clientBundle;
    int nbTasksToSend;
    final String jobUuid;

    JobEntry(ServerTaskBundleClient clientBundle) {
        this.clientBundle = clientBundle;
        this.jobUuid = clientBundle.getUuid();
        this.nbTasksToSend = clientBundle.getPendingTasksCount();
    }

    public int getPendingTasksCount() {
        if (this.clientBundle == null) {
            throw new IllegalStateException("initialBundleWrapper is null");
        }
        return this.clientBundle.getPendingTasksCount();
    }

    public ServerTaskBundleClient getBundle() {
        return this.clientBundle;
    }

    void jobEnded() {
        ServerTaskBundleClient bundle = this.getBundle();
        if (bundle != null) {
            bundle.bundleEnded();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "jobUuid=" + this.jobUuid + ", jobName=" + this.clientBundle.getJob().getName() + ", nbTasksToSend=" + this.nbTasksToSend + ", bundleId=" + this.clientBundle.getId() + ", bundle=" + this.clientBundle + ']';
    }
}

