/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.heartbeat;

import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.comm.recovery.HeartbeatMessage;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.nio.AbstractNioContext;
import org.jppf.nio.NioContext;
import org.jppf.nio.NioMessage;
import org.jppf.nio.SimpleNioMessage;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.classloader.node.AsyncNodeClassContext;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.nio.heartbeat.HeartbeatNioServer;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatContext
extends AbstractNioContext {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    static final AtomicLong messageSequence = new AtomicLong(0L);
    private final AtomicBoolean submitted = new AtomicBoolean(false);
    final HeartbeatNioServer server;

    HeartbeatContext(HeartbeatNioServer server, SocketChannel socketChannel) {
        this.server = server;
        this.socketChannel = socketChannel;
    }

    public boolean readMessage() throws Exception {
        if (this.readMessage == null) {
            this.readMessage = new SimpleNioMessage((NioContext)this);
        }
        this.readByteCount = this.readMessage.getChannelReadCount();
        boolean b = this.readMessage.read();
        this.readByteCount = this.readMessage.getChannelReadCount() - this.readByteCount;
        return b;
    }

    public boolean writeMessage() throws Exception {
        if (this.writeMessage == null) {
            this.createWriteMessage(this.newHeartbeatMessage());
        }
        this.writeByteCount = this.writeMessage.getChannelWriteCount();
        boolean b = this.writeMessage.write();
        this.writeByteCount = this.writeMessage.getChannelWriteCount() - this.writeByteCount;
        return b;
    }

    HeartbeatMessage deserializeData(NioMessage message) throws Exception {
        if (message == null) {
            return null;
        }
        return (HeartbeatMessage)IOHelper.unwrappedData((DataLocation)((SimpleNioMessage)message).getCurrentDataLocation());
    }

    public NioMessage createWriteMessage(HeartbeatMessage data) throws Exception {
        this.writeMessage = new SimpleNioMessage((NioContext)this);
        ((SimpleNioMessage)this.writeMessage).setCurrentDataLocation(IOHelper.serializeData((Object)data));
        return this.writeMessage;
    }

    public HeartbeatMessage newHeartbeatMessage() {
        HeartbeatMessage data = new HeartbeatMessage(messageSequence.incrementAndGet());
        if (this.uuid == null) {
            TypedProperties config = this.server.driver.getConfiguration();
            TypedProperties props = data.getProperties();
            props.set(JPPFProperties.RECOVERY_MAX_RETRIES, config.get(JPPFProperties.RECOVERY_MAX_RETRIES));
            props.set(JPPFProperties.RECOVERY_READ_TIMEOUT, config.get(JPPFProperties.RECOVERY_READ_TIMEOUT));
            props.set(JPPFProperties.RECOVERY_ENABLED, config.get(JPPFProperties.RECOVERY_ENABLED));
        }
        return data;
    }

    void heartbeatFailed() {
        if (debugEnabled) {
            log.debug("node {} failed to respond to heartbeat messages, closing the associated node channels", (Object)this);
        }
        JPPFDriver driver = this.server.driver;
        if (this.server.getIdentifier() == 65527) {
            AsyncNodeClassContext nodeClassChannel;
            AsyncNodeContext nodeContext = driver.getAsyncNodeNioServer().getConnection(this.uuid);
            if (nodeContext != null) {
                driver.getAsyncNodeNioServer().connectionFailed(nodeContext);
            }
            if ((nodeClassChannel = driver.getAsyncNodeClassServer().getNodeConnection(this.uuid)) != null) {
                driver.getAsyncNodeClassServer().connectionFailed(nodeClassChannel);
            }
        } else {
            AsyncClientNioServer server = driver.getAsyncClientNioServer();
            driver.getAsyncClientNioServer().performContextAction(ctx -> this.uuid.equals(ctx.getUuid()), server::closeConnection);
            driver.getAsyncClientClassServer().removeProviderConnections(this.uuid);
        }
        this.handleException(null);
    }

    public void handleException(Exception e) {
        if (e == null) {
            log.info("closing heartbeat channel {}", (Object)this);
        } else if (debugEnabled) {
            log.debug("closing heartbeat channel {} due to exception:\n{}", (Object)this, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        } else {
            log.warn("closing heartbeat channel {} due to exception: {}", (Object)this, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        this.server.closeConnection(this);
    }

    public AtomicBoolean getSubmitted() {
        return this.submitted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", ssl=").append(this.ssl);
        sb.append(", interestOps=").append(this.getInterestOps());
        sb.append(", socketChannel=").append(this.getSocketChannel());
        return sb.append(']').toString();
    }
}

