/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.heartbeat;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.jppf.comm.recovery.HeartbeatMessage;
import org.jppf.server.nio.heartbeat.HeartbeatContext;
import org.jppf.server.nio.heartbeat.HeartbeatNioServer;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ConcurrentUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatMessageHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final Map<Long, HeartbeatMessage> map = new HashMap<Long, HeartbeatMessage>();
    private final long timeout;
    private final int maxTries;
    private final HeartbeatNioServer server;
    private final ExecutorService executor;
    private final Timer timer;
    private final List<HeartbeatContext> channels = new LinkedList<HeartbeatContext>();

    HeartbeatMessageHandler(HeartbeatNioServer server) {
        this.server = server;
        TypedProperties config = server.driver.getConfiguration();
        this.timeout = ((Integer)config.get(JPPFProperties.RECOVERY_READ_TIMEOUT)).intValue();
        this.maxTries = (Integer)config.get(JPPFProperties.RECOVERY_MAX_RETRIES);
        if (debugEnabled) {
            log.debug("configuring HeartbeatMessageHandler with timeout = {}, maxTries = {}", (Object)this.timeout, (Object)this.maxTries);
        }
        this.executor = this.initExecutor();
        this.timer = new Timer("HeartbeatTimer", true);
        this.timer.schedule((TimerTask)new ReaperTask(), this.timeout, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChannel(HeartbeatContext context) {
        if (debugEnabled) {
            log.debug("add new channel {}", (Object)context);
        }
        List<HeartbeatContext> list = this.channels;
        synchronized (list) {
            this.channels.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannel(HeartbeatContext context) {
        if (debugEnabled) {
            log.debug("removing channel {}", (Object)context);
        }
        List<HeartbeatContext> list = this.channels;
        synchronized (list) {
            this.channels.remove((Object)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(HeartbeatContext context) throws Exception {
        try {
            int nbTries = 0;
            boolean done = false;
            while (nbTries < this.maxTries && !done) {
                ++nbTries;
                HeartbeatMessage data = context.newHeartbeatMessage();
                context.createWriteMessage(data);
                Object object = this.map;
                synchronized (object) {
                    this.map.put(data.getMessageID(), data);
                }
                if (debugEnabled) {
                    log.debug("about to send {} to {}", (Object)data, (Object)context);
                }
                this.server.updateInterestOps(context.getSelectionKey(), 4, true);
                object = data;
                synchronized (object) {
                    data.wait(this.timeout);
                    done = data.getResponse() != null;
                }
                if (done) continue;
                if (debugEnabled) {
                    log.debug("node hasn't responded to {}/{} successive heartbeat messages at {} ms intervals: {}", new Object[]{nbTries, this.maxTries, this.timeout, context});
                }
                object = this.map;
                synchronized (object) {
                    this.map.remove(data.getMessageID());
                }
            }
            if (!done) {
                log.error("node failed to respond to {} successive heartbeat messages at {} ms intervals: {}", new Object[]{this.maxTries, this.timeout, context});
                context.heartbeatFailed();
            }
        }
        finally {
            context.getSubmitted().set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void responseReceived(HeartbeatMessage response) {
        HeartbeatMessage request;
        if (debugEnabled) {
            log.debug("received response {}", (Object)response);
        }
        HeartbeatMessage heartbeatMessage = this.map;
        synchronized (heartbeatMessage) {
            request = this.map.remove(response.getMessageID());
        }
        if (request != null) {
            heartbeatMessage = request;
            synchronized (heartbeatMessage) {
                request.setResponse(response);
                request.notifyAll();
            }
            if (debugEnabled) {
                log.debug("found entry in the map for response {}", (Object)response);
            }
        } else if (debugEnabled) {
            log.debug("no entry found in the map for response {}", (Object)response);
        }
    }

    private ExecutorService initExecutor() {
        TypedProperties config = this.server.driver.getConfiguration();
        int core = (Integer)config.get(JPPFProperties.RECOVERY_REAPER_POOL_SIZE);
        return ConcurrentUtils.newFixedExecutor((int)core, (long)this.timeout, (String)"HeartbeatServer");
    }

    class ReaperTask
    extends TimerTask {
        ReaperTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HeartbeatContext[] channelsToCheck;
            HeartbeatContext[] heartbeatContextArray = HeartbeatMessageHandler.this.channels;
            synchronized (heartbeatContextArray) {
                if (HeartbeatMessageHandler.this.channels.isEmpty()) {
                    return;
                }
                channelsToCheck = HeartbeatMessageHandler.this.channels.toArray(new HeartbeatContext[HeartbeatMessageHandler.this.channels.size()]);
            }
            for (final HeartbeatContext channel : channelsToCheck) {
                if (!channel.getSubmitted().compareAndSet(false, true)) continue;
                if (debugEnabled) {
                    log.debug("submitting heartbeat for {}", (Object)channel);
                }
                HeartbeatMessageHandler.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HeartbeatMessageHandler.this.sendMessage(channel);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

