/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.heartbeat;

import org.jppf.comm.recovery.HeartbeatMessage;
import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageReader;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.nio.heartbeat.HeartbeatContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatMessageReader
extends NioMessageReader<HeartbeatContext> {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatMessageReader.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public HeartbeatMessageReader(StatelessNioServer<HeartbeatContext> server) {
        super(server);
    }

    protected NioMessageReader.MessageHandler<HeartbeatContext> createMessageHandler() {
        return HeartbeatMessageReader::handleMessage;
    }

    private static void handleMessage(HeartbeatContext context, NioMessage message) throws Exception {
        if (debugEnabled) {
            log.debug("read message = {} from context = {}", (Object)message, (Object)context);
        }
        HeartbeatMessage heartbeatMessage = context.deserializeData(message);
        if (debugEnabled) {
            log.debug("read message {} from {}", (Object)message, (Object)context);
        }
        if (context.getUuid() == null) {
            String uuid = heartbeatMessage.getUuid();
            context.setUuid(uuid);
        }
        context.server.getMessageHandler().responseReceived(heartbeatMessage);
    }
}

