/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.heartbeat;

import java.io.EOFException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jppf.nio.NioChannelHandler;
import org.jppf.nio.SSLHandler;
import org.jppf.nio.SSLHandlerImpl;
import org.jppf.nio.StatelessNioServer;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.heartbeat.HeartbeatContext;
import org.jppf.server.nio.heartbeat.HeartbeatMessageHandler;
import org.jppf.server.nio.heartbeat.HeartbeatMessageReader;
import org.jppf.server.nio.heartbeat.HeartbeatMessageWriter;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeartbeatNioServer
extends StatelessNioServer<HeartbeatContext> {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatNioServer.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final HeartbeatMessageHandler messageHandler;
    final JPPFDriver driver;

    public HeartbeatNioServer(JPPFDriver driver, int identifier, boolean useSSL) throws Exception {
        super(identifier, useSSL, driver.getConfiguration());
        this.driver = driver;
        this.messageHandler = new HeartbeatMessageHandler(this);
    }

    protected void handleSelectionException(SelectionKey key, Exception e) {
        HeartbeatContext context = (HeartbeatContext)((Object)key.attachment());
        if (e instanceof CancelledKeyException) {
            if (context != null && !context.isClosed()) {
                log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                this.closeConnection(context);
            }
        } else if (e instanceof EOFException) {
            if (debugEnabled) {
                log.debug("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            this.closeConnection(context);
        } else {
            log.error("error on {} :\n{}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            if (context != null) {
                this.closeConnection(context);
            }
        }
    }

    public void accept(ServerSocketChannel serverSocketChannel, SocketChannel channel, SSLHandler sslHandler, boolean ssl, boolean peer, Object ... params) {
        try {
            if (debugEnabled) {
                log.debug("accepting socketChannel = {}", (Object)channel);
            }
            HeartbeatContext context = this.createContext(channel, ssl);
            this.registerChannel((NioChannelHandler)context, channel);
            this.messageHandler.addChannel(context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private HeartbeatContext createContext(SocketChannel channel, boolean ssl) throws Exception {
        HeartbeatContext context = this.createNioContext(channel);
        if (debugEnabled) {
            log.debug("creating channel wrapper for ssl={}, context={}", (Object)ssl, (Object)context);
        }
        context.setSsl(ssl);
        if (ssl) {
            if (debugEnabled) {
                log.debug("creating SSLEngine for {}", (Object)context);
            }
            HeartbeatNioServer.configureSSL(context);
        }
        return context;
    }

    private static void configureSSL(HeartbeatContext context) throws Exception {
        if (debugEnabled) {
            log.debug("configuring SSL for {}", (Object)context);
        }
        SocketChannel channel = context.getSocketChannel();
        SSLContext sslContext = SSLHelper.getSSLContext((int)65527);
        InetSocketAddress addr = (InetSocketAddress)channel.getRemoteAddress();
        SSLEngine engine = sslContext.createSSLEngine(addr.getHostString(), addr.getPort());
        SSLParameters params = SSLHelper.getSSLParameters();
        engine.setUseClientMode(false);
        engine.setSSLParameters(params);
        if (debugEnabled) {
            log.debug("created SSLEngine: useClientMode = {}, parameters = {}", (Object)engine.getUseClientMode(), (Object)engine.getSSLParameters());
        }
        SSLHandlerImpl sslHandler = new SSLHandlerImpl(channel, engine);
        context.setSSLHandler((SSLHandler)sslHandler);
    }

    public HeartbeatContext createNioContext(Object ... params) {
        return new HeartbeatContext(this, (SocketChannel)params[0]);
    }

    void closeConnection(HeartbeatContext context) {
        try {
            this.messageHandler.removeChannel(context);
            SelectionKey key = context.getSocketChannel().keyFor(this.selector);
            if (key != null) {
                key.cancel();
                key.channel().close();
            }
        }
        catch (Exception e) {
            log.error("error closing channel {}: {}", (Object)context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        super.removeAllConnections();
    }

    public HeartbeatMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    protected void initReaderAndWriter() {
        this.messageReader = new HeartbeatMessageReader(this);
        this.messageWriter = new HeartbeatMessageWriter(this);
    }

    protected void initNioHandlers() {
        super.initNioHandlers();
        this.acceptHandler = null;
    }
}

