/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.execute.ExecutorChannel;
import org.jppf.execute.ExecutorChannelStatusEvent;
import org.jppf.execute.ExecutorChannelStatusListener;
import org.jppf.execute.ExecutorStatus;
import org.jppf.load.balancer.Bundler;
import org.jppf.load.balancer.ChannelAwareness;
import org.jppf.load.balancer.ContextAwareness;
import org.jppf.load.balancer.JPPFContext;
import org.jppf.load.balancer.persistence.LoadBalancerPersistenceManager;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.management.JMXConnectionWrapperListener;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.nio.AbstractNioContext;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.NodeConnectionCompletionListener;
import org.jppf.server.nio.nodeserver.NodeJMXWrapperListener;
import org.jppf.server.nio.nodeserver.NodeReservationHandler;
import org.jppf.server.nio.nodeserver.async.AsyncNodeNioServer;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFVoidCallable;
import org.jppf.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNodeContext
extends AbstractNioContext
implements ExecutorChannel<ServerTaskBundleNode> {
    private static final Logger log = LoggerFactory.getLogger(BaseNodeContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private Bundler<?> bundler;
    private JPPFSystemInformation systemInfo;
    private JPPFManagementInfo managementInfo;
    private final List<ExecutorChannelStatusListener> executorChannelListeners = new CopyOnWriteArrayList<ExecutorChannelStatusListener>();
    private final AtomicBoolean active = new AtomicBoolean(true);
    private JMXNodeConnectionWrapper jmxConnection;
    private JMXDriverConnectionWrapper peerJmxConnection;
    private ExecutorStatus executionStatus = ExecutorStatus.DISABLED;
    private NodeReservationHandler.Transition reservationTansition = NodeReservationHandler.Transition.REMOVE;
    private int reservationScore;
    private Pair<String, String> nodeIdentifier;
    private String bundlerAlgorithm;
    private final LoadBalancerPersistenceManager bundlerHandler;
    private final NodeConnectionCompletionListener listener;
    private boolean offline = false;
    protected final JPPFDriver driver;
    protected final AsyncNodeNioServer server;
    private final AtomicBoolean idle = new AtomicBoolean(false);

    public BaseNodeContext(AsyncNodeNioServer server) {
        this.server = server;
        this.driver = server.getDriver();
        this.bundlerHandler = server.getBundlerHandler();
        this.listener = server;
    }

    public Bundler<?> getBundler() {
        return this.bundler;
    }

    public void setBundler(Bundler<?> bundler) {
        this.bundler = bundler;
    }

    public Bundler<?> checkBundler(JPPFBundlerFactory factory, JPPFContext jppfContext) {
        if (factory == null) {
            throw new IllegalArgumentException("Bundler factory is null");
        }
        Bundler bundler = this.getBundler();
        if (bundler == null || bundler.getTimestamp() < factory.getLastUpdateTime()) {
            if (bundler != null) {
                bundler.dispose();
                if (bundler instanceof ContextAwareness) {
                    ((ContextAwareness)bundler).setJPPFContext(null);
                }
            }
            Pair pair = this.bundlerHandler.loadBundler(this.nodeIdentifier);
            this.setBundler((Bundler)pair.second());
            this.bundlerAlgorithm = (String)pair.first();
            bundler = (Bundler)pair.second();
            if (bundler instanceof ContextAwareness) {
                ((ContextAwareness)bundler).setJPPFContext(jppfContext);
            }
            bundler.setup();
            if (bundler instanceof ChannelAwareness) {
                ((ChannelAwareness)bundler).setChannelConfiguration(this.systemInfo);
            }
        }
        return bundler;
    }

    public JPPFSystemInformation getSystemInformation() {
        return this.systemInfo;
    }

    public void setNodeInfo(JPPFSystemInformation systemInfo, boolean update) {
        if (update && debugEnabled) {
            log.debug("updating node information for {}", (Object)systemInfo);
        }
        this.systemInfo = systemInfo;
        systemInfo.getJppf().setProperty("jppf.channel.local", String.valueOf(this.isLocal()));
        if (this.managementInfo != null) {
            this.managementInfo.setSystemInfo(systemInfo);
        }
    }

    public JPPFManagementInfo getManagementInfo() {
        return this.managementInfo;
    }

    public void setManagementInfo(JPPFManagementInfo managementInfo) {
        if (debugEnabled) {
            log.debug("context " + (Object)((Object)this) + " setting management info [" + managementInfo + "]");
        }
        this.managementInfo = managementInfo;
        if (managementInfo.getIpAddress() != null && managementInfo.getPort() >= 0) {
            this.initializeJmxConnection();
        }
    }

    public JMXNodeConnectionWrapper getJmxConnection() {
        return this.jmxConnection;
    }

    public void setJmxConnection(JMXNodeConnectionWrapper jmxConnection) {
        this.jmxConnection = jmxConnection;
    }

    public JMXDriverConnectionWrapper getPeerJmxConnection() {
        return this.peerJmxConnection;
    }

    public void setPeerJmxConnection(JMXDriverConnectionWrapper peerJmxConnection) {
        this.peerJmxConnection = peerJmxConnection;
    }

    public void initializeJmxConnection() {
        if (!this.isClosed()) {
            JMXNodeConnectionWrapper jmx = null;
            if (this.isLocal()) {
                jmx = this.jmxConnection = new JMXNodeConnectionWrapper();
            } else {
                JPPFManagementInfo info = this.getManagementInfo();
                if (!this.isPeer()) {
                    jmx = this.jmxConnection = new JMXNodeConnectionWrapper(info.getIpAddress(), info.getPort(), info.isSecure());
                } else {
                    this.peerJmxConnection = new JMXDriverConnectionWrapper(info.getIpAddress(), info.getPort(), info.isSecure());
                    jmx = this.peerJmxConnection;
                }
                if (debugEnabled) {
                    log.debug("establishing JMX connection for {}", (Object)jmx);
                }
            }
            jmx.addJMXConnectionWrapperListener((JMXConnectionWrapperListener)new NodeJMXWrapperListener(this, this.listener));
            jmx.connect();
        } else {
            log.warn("node closed: {}", (Object)this);
        }
    }

    public ExecutorStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutorStatus newStatus) {
        ExecutorStatus oldStatus = this.executionStatus;
        this.executionStatus = newStatus;
        this.fireExecutionStatusChanged(oldStatus, newStatus);
    }

    public NodeReservationHandler.Transition getReservationTansition() {
        return this.reservationTansition;
    }

    public void setReservationTansition(NodeReservationHandler.Transition reservationTansition) {
        this.reservationTansition = reservationTansition;
    }

    public int getReservationScore() {
        return this.reservationScore;
    }

    public void setReservationScore(int reservationScore) {
        this.reservationScore = reservationScore;
    }

    public Pair<String, String> getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(Pair<String, String> nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public String getBundlerAlgorithm() {
        return this.bundlerAlgorithm;
    }

    public void setBundlerAlgorithm(String bundlerAlgorithm) {
        this.bundlerAlgorithm = bundlerAlgorithm;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        this.active.set(active);
        if (this.managementInfo != null) {
            this.managementInfo.setIsActive(active);
        }
    }

    public void addExecutionStatusListener(ExecutorChannelStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.executorChannelListeners.add(listener);
    }

    public void removeExecutionStatusListener(ExecutorChannelStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.executorChannelListeners.remove(listener);
    }

    public void fireExecutionStatusChanged(ExecutorStatus oldValue, ExecutorStatus newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (debugEnabled) {
            log.debug("changing execution status from {} to {} on {}", new Object[]{oldValue, newValue, this});
        }
        ExecutorChannelStatusEvent event = new ExecutorChannelStatusEvent((Object)this, oldValue, newValue);
        for (ExecutorChannelStatusListener listener : this.executorChannelListeners) {
            listener.executionStatusChanged(event);
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public JPPFDriver getDriver() {
        return this.driver;
    }

    public AtomicBoolean getIdle() {
        return this.idle;
    }

    public boolean cancelJob(String jobId, boolean requeue) throws Exception {
        if (debugEnabled) {
            log.debug("cancelling job uuid={} from {}, jmxConnection={}, peerJmxConnection={}", new Object[]{jobId, this, this.getJmxConnection(), this.getPeerJmxConnection()});
        }
        if (this.isOffline()) {
            return false;
        }
        JPPFVoidCallable & Serializable cancelCallback = null;
        if (!this.isPeer() && this.getJmxConnection() != null && this.getJmxConnection().isConnected()) {
            cancelCallback = (JPPFVoidCallable & Serializable)() -> this.getJmxConnection().cancelJob(jobId, Boolean.valueOf(requeue));
        } else if (this.isPeer() && this.getPeerJmxConnection() != null && this.getPeerJmxConnection().isConnected()) {
            cancelCallback = (JPPFVoidCallable & Serializable)() -> this.getPeerJmxConnection().cancelJob(jobId);
        }
        if (cancelCallback != null) {
            try {
                cancelCallback.call();
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                } else {
                    log.warn(ExceptionUtils.getMessage((Throwable)e));
                }
                throw e;
            }
            return true;
        }
        return false;
    }
}

