/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver;

import java.util.List;
import org.jppf.io.DataLocation;
import org.jppf.job.JobReturnReason;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.nio.nodeserver.OfflineNodeHandler;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDispatchTimeoutAction
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(NodeDispatchTimeoutAction.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final OfflineNodeHandler server;
    private final ServerTaskBundleNode nodeBundle;
    private final BaseNodeContext context;

    public NodeDispatchTimeoutAction(OfflineNodeHandler server, ServerTaskBundleNode nodeBundle, BaseNodeContext context) {
        if (server == null) {
            throw new IllegalArgumentException("server cannot be null");
        }
        if (nodeBundle == null) {
            throw new IllegalArgumentException("node bundle cannot be null");
        }
        this.server = server;
        this.nodeBundle = nodeBundle;
        this.context = context;
    }

    @Override
    public void run() {
        if (!this.nodeBundle.getJob().isHandshake()) {
            if (debugEnabled) {
                log.debug("node dispatch expiring : {}, context={}", (Object)this.nodeBundle, (Object)this.context);
            }
            this.nodeBundle.expire();
            String jobUuid = this.nodeBundle.getJob().getUuid();
            if (this.context == null) {
                this.server.removeNodeBundle(jobUuid, this.nodeBundle.getId());
                this.nodeBundle.setJobReturnReason(JobReturnReason.DISPATCH_TIMEOUT);
                this.nodeBundle.resultsReceived((List<DataLocation>)null);
            } else {
                try {
                    this.context.cancelJob(jobUuid, false);
                }
                catch (Exception e) {
                    if (debugEnabled) {
                        log.debug("error cancelling job {} : {}", (Object)this.context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    log.warn("error cancelling job {} : {}", (Object)this.context, (Object)ExceptionUtils.getMessage((Throwable)e));
                }
            }
        }
    }
}

