/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver;

import org.jppf.management.JMXConnectionWrapperEvent;
import org.jppf.management.JMXConnectionWrapperListener;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.nio.nodeserver.NodeConnectionCompletionListener;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJMXWrapperListener
implements JMXConnectionWrapperListener {
    private static Logger log = LoggerFactory.getLogger(NodeJMXWrapperListener.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final BaseNodeContext context;
    private final NodeConnectionCompletionListener listener;

    public NodeJMXWrapperListener(BaseNodeContext context, NodeConnectionCompletionListener listener) {
        this.context = context;
        this.listener = listener;
    }

    public void onConnected(JMXConnectionWrapperEvent event) {
        if (debugEnabled) {
            log.debug("JMX connection established from {}, for {}", (Object)this, (Object)this.context);
        }
        if (this.context.getJmxConnection() != null) {
            this.context.getJmxConnection().removeJMXConnectionWrapperListener((JMXConnectionWrapperListener)this);
        } else if (this.context.getPeerJmxConnection() != null) {
            this.context.getPeerJmxConnection().removeJMXConnectionWrapperListener((JMXConnectionWrapperListener)this);
        }
        this.listener.nodeConnected(this.context);
    }

    public void onConnectionTimeout(JMXConnectionWrapperEvent event) {
        if (debugEnabled) {
            log.debug("received jmxWrapperTimeout() for {}, exception: {}", (Object)this.context, (Object)ExceptionUtils.getStackTrace((Throwable)event.getJMXConnectionWrapper().getLastConnectionException()));
        }
        if (this.context.getJmxConnection() != null) {
            this.context.getJmxConnection().removeJMXConnectionWrapperListener((JMXConnectionWrapperListener)this);
        } else if (this.context.getPeerJmxConnection() != null) {
            this.context.getPeerJmxConnection().removeJMXConnectionWrapperListener((JMXConnectionWrapperListener)this);
        }
        this.context.setJmxConnection(null);
        this.context.setPeerJmxConnection(null);
        this.listener.nodeConnected(this.context);
    }
}

