/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.nio.NioHelper;
import org.jppf.node.protocol.JPPFNodeConfigSpec;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.protocol.ServerJob;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetHashMap;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeReservationHandler {
    private static final Logger log = LoggerFactory.getLogger(NodeReservationHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final Map<String, String> pendingMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> readyMap = new ConcurrentHashMap<String, String>();
    private final CollectionMap<String, String> jobPendingMap = new SetHashMap();
    private final CollectionMap<String, String> jobReadyMap = new SetHashMap();
    private final JPPFDriver driver;

    public NodeReservationHandler(JPPFDriver driver) {
        this.driver = driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReservation(ServerJob job, BaseNodeContext node) {
        if (debugEnabled) {
            log.debug("reserving node {} for job {}", (Object)node.getUuid(), (Object)job.getUuid());
        }
        NodeReservationHandler nodeReservationHandler = this;
        synchronized (nodeReservationHandler) {
            this.pendingMap.put(node.getUuid(), job.getUuid());
            this.jobPendingMap.putValue((Object)job.getUuid(), (Object)node.getUuid());
        }
        NioHelper.getGlobalexecutor().execute(new NodeReservationTask(job, node));
    }

    public synchronized void removeReservation(BaseNodeContext node) {
        String jobUuid;
        if (node == null) {
            return;
        }
        String nodeUuid = node.getUuid();
        if (nodeUuid == null) {
            return;
        }
        if (debugEnabled) {
            log.debug("removing reservations for node {}", (Object)node);
        }
        if ((jobUuid = this.pendingMap.remove(nodeUuid)) != null) {
            this.jobPendingMap.removeValue((Object)jobUuid, (Object)nodeUuid);
        }
        if ((jobUuid = this.readyMap.remove(node.getUuid())) != null) {
            this.jobReadyMap.removeValue((Object)jobUuid, (Object)nodeUuid);
        }
        node.setReservationTansition(Transition.REMOVE);
    }

    public synchronized void onJobCancelled(ServerJob job) {
        if (debugEnabled) {
            log.debug("job {} cancelled, removing all reservations", (Object)job.getUuid());
        }
        this.removeJobReservations(job.getUuid());
    }

    public synchronized void removeJobReservations(String jobUuid) {
        Collection nodes;
        if (debugEnabled) {
            log.debug("removing all reservations for job {}", (Object)jobUuid);
        }
        if ((nodes = this.jobPendingMap.removeKey((Object)jobUuid)) != null) {
            if (debugEnabled) {
                log.debug("removing {} pending node reservations for cancelled job {}", (Object)nodes.size(), (Object)jobUuid);
            }
            for (String nodeUuid : nodes) {
                this.pendingMap.remove(nodeUuid);
            }
        }
        if ((nodes = this.jobReadyMap.removeKey((Object)jobUuid)) != null) {
            if (debugEnabled) {
                log.debug("removing {} ready node reservations for cancelled job {}", (Object)nodes.size(), (Object)jobUuid);
            }
            for (String nodeUuid : nodes) {
                this.readyMap.remove(nodeUuid);
            }
        }
    }

    public synchronized String getPendingJobUUID(BaseNodeContext node) {
        return this.pendingMap.get(node.getUuid());
    }

    public synchronized String getReadyJobUUID(BaseNodeContext node) {
        return this.readyMap.get(node.getUuid());
    }

    synchronized boolean hasPendingNode(String jobUuid) {
        return this.jobPendingMap.getValues((Object)jobUuid) != null;
    }

    public synchronized boolean hasReadyNode(String jobUuid) {
        return this.jobReadyMap.getValues((Object)jobUuid) != null;
    }

    public synchronized Collection<String> getReadyNodes(String jobUuid) {
        return this.jobReadyMap.getValues((Object)jobUuid);
    }

    public synchronized int getNbReservedNodes(String jobUuid) {
        int result = 0;
        Collection nodes = this.jobPendingMap.getValues((Object)jobUuid);
        if (nodes != null) {
            result += nodes.size();
        }
        if ((nodes = this.jobReadyMap.getValues((Object)jobUuid)) != null) {
            result += nodes.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitionReservation(BaseNodeContext node) {
        TypedProperties config = node.getSystemInformation().getJppf();
        String reservedJobUuid = (String)config.get(JPPFProperties.NODE_RESERVED_JOB);
        if (reservedJobUuid != null) {
            if (debugEnabled) {
                log.debug("node {} is reserved for job {}", (Object)node.getUuid(), (Object)reservedJobUuid);
            }
            String oldNodeUuid = (String)config.get(JPPFProperties.NODE_RESERVED_UUID);
            ServerJob job = this.driver.getQueue().getJob(reservedJobUuid);
            if (debugEnabled) {
                log.debug("job with uuid={} {} in the queue", (Object)reservedJobUuid, (Object)(job == null ? "no longer" : "found"));
            }
            NodeReservationHandler nodeReservationHandler = this;
            synchronized (nodeReservationHandler) {
                if (job != null && job.isCancelled()) {
                    if (debugEnabled) {
                        log.debug("cancelling reservations for job with uuid={}", (Object)reservedJobUuid);
                    }
                    this.onJobCancelled(job);
                    return true;
                }
                String pendingJobUuid = this.pendingMap.get(oldNodeUuid);
                if (debugEnabled) {
                    log.debug("node {} previous uuid was {} and was reserved for job {} (reservedJobUuid={})", new Object[]{node.getUuid(), oldNodeUuid, pendingJobUuid, reservedJobUuid});
                }
                if (reservedJobUuid.equals(pendingJobUuid)) {
                    if (debugEnabled) {
                        log.debug("oldNodeUuid={}, nodeUuid={}, jobUuid={}", new Object[]{oldNodeUuid, node.getUuid(), pendingJobUuid});
                    }
                    this.pendingMap.remove(oldNodeUuid);
                    if (pendingJobUuid != null) {
                        this.readyMap.put(node.getUuid(), pendingJobUuid);
                    }
                    this.jobPendingMap.removeValue((Object)reservedJobUuid, (Object)oldNodeUuid);
                    if (pendingJobUuid != null) {
                        this.jobReadyMap.putValue((Object)pendingJobUuid, (Object)node.getUuid());
                    }
                    node.setReservationTansition(Transition.REMOVE);
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized Map<String, Set<String>> getReservations() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("pendingJobs", new HashSet(this.jobPendingMap.keySet()));
        map.put("readyJobs", new HashSet(this.jobReadyMap.keySet()));
        map.put("pendingNodes", new HashSet<String>(this.pendingMap.keySet()));
        map.put("readyNodes", new HashSet<String>(this.readyMap.keySet()));
        return map;
    }

    public synchronized Set<String> getReservedJobs() {
        HashSet<String> set = new HashSet<String>(this.jobPendingMap.keySet());
        set.addAll(this.jobReadyMap.keySet());
        return set;
    }

    public synchronized Set<String> getReservedNodes() {
        HashSet<String> set = new HashSet<String>(this.pendingMap.keySet());
        set.addAll(this.readyMap.keySet());
        return set;
    }

    private class NodeReservationTask
    implements Runnable {
        private final ServerJob job;
        private final BaseNodeContext node;

        public NodeReservationTask(ServerJob job, BaseNodeContext node) {
            this.job = job;
            this.node = node;
        }

        @Override
        public void run() {
            JPPFNodeConfigSpec spec = this.job.getSLA().getDesiredNodeConfiguration();
            TypedProperties desiredConfig = spec.getConfiguration();
            TypedProperties config = new TypedProperties((Map)desiredConfig).set(JPPFProperties.NODE_RESERVED_JOB, (Object)this.job.getUuid()).set(JPPFProperties.NODE_RESERVED_UUID, (Object)this.node.getUuid());
            JMXNodeConnectionWrapper jmx = this.node.getJmxConnection();
            if (jmx != null && jmx.isConnected()) {
                try {
                    if (debugEnabled) {
                        log.debug("about to restart node {} reserved for job {} with config={}", new Object[]{this.node.getUuid(), this.job.getUuid(), config});
                    }
                    boolean restart = spec.isForceRestart() || this.node.getReservationScore() > 0;
                    this.node.setReservationTansition(Transition.KEEP);
                    if (!restart) {
                        this.node.getSystemInformation().getJppf().putAll((Map)config);
                        NodeReservationHandler.this.transitionReservation(this.node);
                    }
                    jmx.updateConfiguration((Map)config, Boolean.valueOf(restart));
                }
                catch (Exception e) {
                    log.error("error reserving node {} for job {}", (Object)this.node, (Object)this.job);
                }
            }
        }
    }

    public static enum Transition {
        REMOVE,
        KEEP,
        READY;

    }
}

