/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.jppf.load.balancer.Bundler;
import org.jppf.load.balancer.ChannelAwareness;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.JPPFThreadFactory;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerAttributesHandler
implements NotificationListener {
    private static final Logger log = LoggerFactory.getLogger(PeerAttributesHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    public static final String PEER_TOTAL_NODES = "jppf.peer.total.nodes";
    public static final String PEER_TOTAL_THREADS = JPPFProperties.PEER_PROCESSING_THREADS.getName();
    private final ExecutorService executor;
    private final AtomicInteger totalNodes = new AtomicInteger(0);
    private final AtomicInteger totalThreads = new AtomicInteger(0);
    private final AtomicLong notifCount = new AtomicLong(0L);
    private final JPPFDriver driver;

    public PeerAttributesHandler(JPPFDriver driver, int nbThreads) {
        this.driver = driver;
        this.executor = Executors.newFixedThreadPool(nbThreads, (ThreadFactory)new JPPFThreadFactory("PeerHandler"));
    }

    public int getTotalNodes() {
        return this.totalNodes.get();
    }

    public int getTotalThreads() {
        return this.totalThreads.get();
    }

    private static void updatePeer(BaseNodeContext peer, TypedProperties props) {
        int newNodes = props.getInt(PEER_TOTAL_NODES, 0);
        int newThreads = props.getInt(PEER_TOTAL_THREADS, 0);
        JPPFSystemInformation info = peer.getSystemInformation();
        if (debugEnabled) {
            log.debug("updating peer with newNodes={}, newThreads={}, systemInfo={}, peer={}", new Object[]{newNodes, newThreads, info, peer});
        }
        if (info != null) {
            TypedProperties jppf = info.getJppf();
            int nodes = jppf.getInt(PEER_TOTAL_NODES);
            int threads = jppf.getInt(PEER_TOTAL_THREADS);
            if (nodes != newNodes || threads != newThreads) {
                if (debugEnabled) {
                    log.debug("newNodes={}, newThreads={} for " + (Object)((Object)peer), (Object)newNodes, (Object)newThreads);
                }
                jppf.setInt(PEER_TOTAL_NODES, newNodes).setInt(PEER_TOTAL_THREADS, newThreads);
                Bundler<?> bundler = peer.getBundler();
                if (bundler instanceof ChannelAwareness) {
                    ((ChannelAwareness)bundler).setChannelConfiguration(info);
                }
            }
        }
    }

    public void onCloseNode(BaseNodeContext context) {
        if (!context.isPeer()) {
            this.totalNodes.decrementAndGet();
            JPPFSystemInformation sys = context.getSystemInformation();
            if (sys != null) {
                int nbThreads = sys.getJppf().getInt(JPPFProperties.PROCESSING_THREADS.getName(), 1);
                this.totalThreads.addAndGet(-nbThreads);
            }
            this.sendNotification();
            if (debugEnabled) {
                log.debug("totalNodes={}, totalThreads={}", (Object)this.totalNodes, (Object)this.totalThreads);
            }
        } else {
            JMXDriverConnectionWrapper jmx = context.getPeerJmxConnection();
            if (jmx != null) {
                try {
                    jmx.removeNotificationListener("org.jppf:name=peerAttributes,type=driver", (NotificationListener)this, null, (Object)context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void onNodeConnected(BaseNodeContext context) {
        block8: {
            if (!context.isPeer()) {
                this.totalNodes.incrementAndGet();
                JPPFSystemInformation sys = context.getSystemInformation();
                if (sys != null) {
                    int nbThreads = sys.getJppf().getInt(JPPFProperties.PROCESSING_THREADS.getName(), 1);
                    this.totalThreads.addAndGet(nbThreads);
                }
                this.sendNotification();
                if (debugEnabled) {
                    log.debug("totalNodes={}, totalThreads={}", (Object)this.totalNodes, (Object)this.totalThreads);
                }
            } else {
                JMXDriverConnectionWrapper jmx = context.getPeerJmxConnection();
                if (jmx != null) {
                    try {
                        if (debugEnabled) {
                            log.debug("registered peer attributes handler notification listener on node {}", (Object)context);
                        }
                        this.executor.execute(() -> {
                            block2: {
                                try {
                                    PeerAttributesHandler.updatePeer(context, (TypedProperties)jmx.getAttribute("org.jppf:name=peerAttributes,type=driver", "PeerProperties"));
                                }
                                catch (Exception e) {
                                    if (!debugEnabled) break block2;
                                    log.debug("getting peer config for {}", (Object)context, (Object)e);
                                }
                            }
                        });
                        jmx.addNotificationListener("org.jppf:name=peerAttributes,type=driver", (NotificationListener)this, null, (Object)context);
                    }
                    catch (Exception e) {
                        if (!debugEnabled) break block8;
                        log.debug("error registering notification listener", (Throwable)e);
                    }
                }
            }
        }
    }

    private void sendNotification() {
        Notification notif = new Notification("peer.attribute", (Object)"org.jppf:name=peerAttributes,type=driver", this.notifCount.incrementAndGet(), System.currentTimeMillis());
        TypedProperties props = new TypedProperties();
        props.setInt(PEER_TOTAL_NODES, this.totalNodes.get());
        props.setInt(PEER_TOTAL_THREADS, this.totalThreads.get());
        notif.setUserData(props);
        this.driver.getPeerDriver().sendNotification(notif);
    }

    void close() {
        this.executor.shutdownNow();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (debugEnabled) {
            log.debug("received notification {} for {}", notification.getUserData(), handback);
        }
        this.executor.execute(() -> {
            TypedProperties props = (TypedProperties)notification.getUserData();
            PeerAttributesHandler.updatePeer((BaseNodeContext)((Object)((Object)handback)), props);
        });
    }
}

