/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jppf.execute.ExecutorStatus;
import org.jppf.load.balancer.JPPFContext;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.NodeSelectionHelper;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.policy.Preference;
import org.jppf.queue.JPPFQueue;
import org.jppf.server.JPPFContextDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.nio.nodeserver.NodeReservationHandler;
import org.jppf.server.nio.nodeserver.async.AsyncNodeNioServer;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.jppf.server.queue.JobDependenciesHandler;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.PropertiesCollection;
import org.jppf.utils.concurrent.JPPFThreadFactory;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAsyncJobScheduler
extends ThreadSynchronization
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractAsyncJobScheduler.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final boolean disptachtoPeersWithoutNode;
    final Random random = new Random(System.nanoTime());
    final JPPFStatistics stats;
    final JPPFPriorityQueue queue;
    final Set<BaseNodeContext> idleChannels = new LinkedHashSet<BaseNodeContext>();
    final JPPFContext jppfContext;
    private final ExecutorService channelsExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new JPPFThreadFactory("NodeChannels"));
    final JPPFSystemInformation driverInfo;
    final JPPFBundlerFactory bundlerFactory;
    AsyncNodeNioServer server;
    NodeReservationHandler reservationHandler;
    final int peerLoadBalanceThreshold;
    final boolean localNodeBiasEnabled;
    final NodeSelectionHelper selectionHelper;
    final JobDependenciesHandler dependencyHandler;

    AbstractAsyncJobScheduler(AsyncNodeNioServer server, JPPFPriorityQueue queue, JPPFStatistics stats, JPPFBundlerFactory bundlerFactory) {
        this.server = server;
        this.queue = queue;
        this.dependencyHandler = queue.getDependenciesHandler();
        this.disptachtoPeersWithoutNode = (Boolean)server.getDriver().getConfiguration().get(JPPFProperties.PEER_ALLOW_ORPHANS);
        this.jppfContext = new JPPFContextDriver((JPPFQueue<?, ?, ?>)queue);
        this.stats = stats;
        this.bundlerFactory = bundlerFactory;
        this.driverInfo = server.getDriver().getSystemInformation();
        this.peerLoadBalanceThreshold = server.getDriver().getInitializer().getPeerConnectionPoolHandler().getLoadBalanceThreshold();
        this.localNodeBiasEnabled = (Boolean)server.getDriver().getConfiguration().get(JPPFProperties.LOCAL_NODE_BIAS);
        this.selectionHelper = new NodeSelectionHelper(server.getDriver());
    }

    public JPPFContext getJPPFContext() {
        return this.jppfContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNbIdleChannels() {
        Set<BaseNodeContext> set = this.idleChannels;
        synchronized (set) {
            return this.idleChannels.size();
        }
    }

    public void addIdleChannel(BaseNodeContext channel) {
        if (debugEnabled) {
            log.debug("request to add idle channel {}", (Object)channel);
        }
        if (channel == null) {
            String message = "channel is null";
            log.error("channel is null");
            throw new IllegalArgumentException("channel is null");
        }
        if (channel.getExecutionStatus() != ExecutorStatus.ACTIVE) {
            String message = "channel is not active: " + (Object)((Object)channel);
            if (channel.getExecutionStatus() != ExecutorStatus.EXECUTING) {
                log.error(message);
                throw new IllegalStateException(message);
            }
            log.warn("attempting to add EXECUTING channel as idle: {}", (Object)channel);
            return;
        }
        this.channelsExecutor.execute(() -> {
            if (debugEnabled) {
                log.debug("adding idle channel {}", (Object)channel);
            }
            if (!channel.isClosed()) {
                boolean added;
                if (!this.reservationHandler.transitionReservation(channel)) {
                    this.reservationHandler.removeReservation(channel);
                }
                Set<BaseNodeContext> set = this.idleChannels;
                synchronized (set) {
                    added = this.idleChannels.add(channel);
                }
                channel.getIdle().set(true);
                if (added) {
                    JPPFSystemInformation info = channel.getSystemInformation();
                    if (info != null) {
                        info.getJppf().set(JPPFProperties.NODE_IDLE, (Object)true);
                    }
                    this.stats.addValue("idle.nodes", 1.0);
                }
                this.wakeUp();
            } else {
                channel.handleException(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BaseNodeContext removeIdleChannel(BaseNodeContext channel) {
        boolean removed;
        if (debugEnabled) {
            log.debug("removing idle channel {}", (Object)channel);
        }
        Set<BaseNodeContext> set = this.idleChannels;
        synchronized (set) {
            removed = this.idleChannels.remove((Object)channel);
        }
        channel.getIdle().set(false);
        if (removed) {
            JPPFSystemInformation info = channel.getSystemInformation();
            if (info != null) {
                info.getJppf().set(JPPFProperties.NODE_IDLE, (Object)false);
            }
            this.stats.addValue("idle.nodes", -1.0);
        }
        return channel;
    }

    public void removeIdleChannelAsync(BaseNodeContext channel) {
        if (debugEnabled) {
            log.debug("request to remove idle channel {}", (Object)channel);
        }
        this.channelsExecutor.execute(() -> this.removeIdleChannel(channel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseNodeContext> getIdleChannels() {
        Set<BaseNodeContext> set = this.idleChannels;
        synchronized (set) {
            return new ArrayList<BaseNodeContext>(this.idleChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearIdleChannels() {
        Set<BaseNodeContext> set = this.idleChannels;
        synchronized (set) {
            this.idleChannels.clear();
        }
    }

    public static void preparePolicy(ExecutionPolicy policy, ServerJob job, JPPFStatistics stats, int nbJobNodes) {
        if (policy == null) {
            return;
        }
        if (job == null) {
            policy.setContext(null, null, null, nbJobNodes, stats);
        } else {
            policy.setContext(job.getSLA(), null, job.getMetadata(), nbJobNodes, stats);
        }
    }

    Set<BaseNodeContext> filterPreferredNodes(ServerJob job) {
        Preference preferencePolicy = job.getSLA().getPreferencePolicy();
        HashSet<BaseNodeContext> result = new HashSet<BaseNodeContext>();
        for (ExecutionPolicy policy : preferencePolicy.getChildren()) {
            AbstractAsyncJobScheduler.preparePolicy(policy, job, this.stats, job.getNbChannels());
            for (BaseNodeContext node : this.idleChannels) {
                if (!policy.evaluate((PropertiesCollection)node.getSystemInformation())) continue;
                result.add(node);
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return Collections.emptySet();
    }
}

