/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver.async;

import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.execute.ExecutorStatus;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.job.JobReturnReason;
import org.jppf.load.balancer.Bundler;
import org.jppf.load.balancer.ContextAwareness;
import org.jppf.management.JMXConnectionWrapper;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.PositionalElement;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.protocol.graph.TaskGraphInfo;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.server.nio.AbstractTaskBundleMessage;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.nio.nodeserver.LocalNodeMessage;
import org.jppf.server.nio.nodeserver.NodeBundleResults;
import org.jppf.server.nio.nodeserver.NodeReservationHandler;
import org.jppf.server.nio.nodeserver.RemoteNodeMessage;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContextFuture;
import org.jppf.server.nio.nodeserver.async.AsyncNodeNioServer;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeContext
extends BaseNodeContext {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final CollectionMap<String, Long> jobToBundlesIds = new ArrayListHashMap();
    private final Map<String, ServerTaskBundleNode> entryMap = new ConcurrentHashMap<String, ServerTaskBundleNode>();
    private final BlockingQueue<AbstractTaskBundleMessage> sendQueue = new LinkedBlockingQueue<AbstractTaskBundleMessage>();
    private final ThreadSynchronization localNodeReadLock;
    private final ThreadSynchronization localNodeWriteLock;
    private final AtomicInteger maxJobs = new AtomicInteger(0);
    private AtomicBoolean acceptingNewJobs = new AtomicBoolean(true);
    private AtomicBoolean exceptionHandled = new AtomicBoolean(false);

    public AsyncNodeContext(AsyncNodeNioServer server, SocketChannel socketChannel, boolean local) {
        super(server);
        this.socketChannel = socketChannel;
        this.local = socketChannel == null;
        this.localNodeReadLock = local ? new ThreadSynchronization() : null;
        this.localNodeWriteLock = local ? new ThreadSynchronization() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Exception exception) {
        if (!this.isClosed() && this.exceptionHandled.compareAndSet(false, true)) {
            HashMap<String, ServerTaskBundleNode> allEntries;
            if (log.isTraceEnabled()) {
                log.trace("handling exception on {}\n{}\ncall stack:\n{}", new Object[]{this, exception == null ? "null" : ExceptionUtils.getStackTrace((Throwable)exception), ExceptionUtils.getCallStack()});
            } else if (debugEnabled) {
                log.debug("handling exception on {}\n{}", (Object)this, (Object)(exception == null ? "null" : ExceptionUtils.getStackTrace((Throwable)exception)));
            }
            CollectionMap<String, Long> collectionMap = this.jobToBundlesIds;
            synchronized (collectionMap) {
                allEntries = new HashMap<String, ServerTaskBundleNode>(this.entryMap);
                this.clear();
            }
            this.server.closeConnection(this);
            if (debugEnabled) {
                log.debug("handling exception for {} node bundles of {}", (Object)allEntries.size(), (Object)this);
            }
            for (Map.Entry entry : allEntries.entrySet()) {
                this.handleException(exception, (ServerTaskBundleNode)entry.getValue());
            }
        }
    }

    void handleException(Exception exception, ServerTaskBundleNode tmpBundle) {
        try {
            if (tmpBundle != null) {
                this.server.getDispatchExpirationHandler().cancelAction((Object)ServerTaskBundleNode.makeKey(tmpBundle));
                tmpBundle.setJobReturnReason(JobReturnReason.NODE_CHANNEL_ERROR);
                tmpBundle.taskCompleted(exception);
            }
            if (tmpBundle != null && !tmpBundle.getJob().isHandshake()) {
                boolean applyMaxResubmit = tmpBundle.getJob().getSLA().isApplyMaxResubmitsUponNodeError();
                if (debugEnabled) {
                    log.debug("applyMaxResubmit={} for {}", (Object)applyMaxResubmit, (Object)this);
                }
                ArrayList<DataLocation> results = new ArrayList<DataLocation>(tmpBundle.getTaskList().size());
                if (!applyMaxResubmit) {
                    tmpBundle.resubmit();
                    for (ServerTask task : tmpBundle.getTaskList()) {
                        results.add(task.getInitialTask());
                        task.resubmit();
                    }
                } else {
                    int count = 0;
                    for (ServerTask task : tmpBundle.getTaskList()) {
                        results.add(task.getInitialTask());
                        int max = tmpBundle.getJob().getSLA().getMaxTaskResubmits();
                        if (task.incResubmitCount() > max) continue;
                        task.resubmit();
                        ++count;
                    }
                    if (debugEnabled) {
                        log.debug("resubmit count={} for {}", (Object)count, (Object)this);
                    }
                    if (count > 0) {
                        this.updateStatsUponTaskResubmit(count);
                    }
                }
                tmpBundle.resultsReceived(results);
                this.updateStatsUponTaskResubmit(tmpBundle.getTaskCount());
            }
        }
        catch (Exception e) {
            log.error("error in handleException() for " + (Object)((Object)this) + " : ", (Throwable)e);
        }
    }

    public AbstractTaskBundleMessage serializeBundle(ServerTaskBundleNode bundle) throws Exception {
        bundle.checkTaskCount();
        TaskBundle taskBundle = bundle.getJob();
        AbstractTaskBundleMessage message = this.newMessage();
        taskBundle.setBundleId(Long.valueOf(bundle.getId()));
        TaskGraphInfo graphInfo = bundle.getTaskGraphInfo();
        if (!taskBundle.isHandshake()) {
            if (!this.isPeer()) {
                taskBundle.removeParameter((Object)BundleParameter.TASK_MAX_RESUBMITS);
            } else {
                if (bundle.getServerJob().isPersistent()) {
                    taskBundle.setParameter((Object)BundleParameter.ALREADY_PERSISTED_P2P, (Object)true);
                }
                int[] positions = new int[bundle.getTaskCount()];
                int count = 0;
                for (ServerTask task : bundle.getTaskList()) {
                    positions[count++] = task.getPosition();
                }
                taskBundle.setParameter((Object)BundleParameter.TASK_POSITIONS, (Object)positions);
            }
            if (graphInfo != null) {
                int depCount = graphInfo.getDependencies().size();
                if (debugEnabled) {
                    log.debug("there are {} dependencies for {}", (Object)depCount, (Object)this);
                }
                taskBundle.setParameter((Object)BundleParameter.JOB_TASK_GRAPH_INFO, (Object)graphInfo);
            }
        }
        message.addLocation(IOHelper.serializeData((Object)taskBundle, (ObjectSerializer)this.server.getDriver().getSerializer()));
        message.addLocation(bundle.getDataProvider());
        for (ServerTask task : bundle.getTaskList()) {
            message.addLocation(task.getInitialTask());
        }
        if (graphInfo != null) {
            for (PositionalElement elt : graphInfo.getDependencies()) {
                ServerTask task = (ServerTask)elt;
                if (debugEnabled) {
                    log.debug("adding dependency {} with result = {}", (Object)task, (Object)task.getResult());
                }
                message.addLocation(task.getResult());
            }
        }
        message.setBundle(taskBundle);
        return message;
    }

    public NodeBundleResults deserializeBundle(AbstractTaskBundleMessage message) throws Exception {
        List locations = message.getLocations();
        if (message.getBundle() == null) {
            message.setBundle((TaskBundle)IOHelper.unwrappedData((DataLocation)((DataLocation)locations.get(0))));
        }
        TaskBundle bundle = message.getBundle();
        ArrayList<DataLocation> tasks = new ArrayList<DataLocation>();
        if (locations.size() > 1) {
            for (int i = 1; i < locations.size(); ++i) {
                tasks.add((DataLocation)locations.get(i));
            }
        }
        return new NodeBundleResults(bundle, tasks);
    }

    public AbstractTaskBundleMessage newMessage() {
        return this.isLocal() ? new LocalNodeMessage(this) : new RemoteNodeMessage(this);
    }

    public boolean readMessage() throws Exception {
        if (this.readMessage == null) {
            this.readMessage = this.newMessage();
        }
        this.readByteCount = this.readMessage.getChannelReadCount();
        boolean b = false;
        try {
            b = this.readMessage.read();
        }
        catch (Exception e) {
            this.updateTrafficStats((AbstractTaskBundleMessage)this.readMessage);
            throw e;
        }
        this.readByteCount = this.readMessage.getChannelReadCount() - this.readByteCount;
        if (b) {
            this.updateTrafficStats((AbstractTaskBundleMessage)this.readMessage);
        }
        return b;
    }

    public boolean writeMessage() throws Exception {
        this.writeByteCount = this.writeMessage.getChannelWriteCount();
        boolean b = false;
        try {
            b = this.writeMessage.write();
        }
        catch (Exception e) {
            this.updateTrafficStats((AbstractTaskBundleMessage)this.writeMessage);
            throw e;
        }
        this.writeByteCount = this.writeMessage.getChannelWriteCount() - this.writeByteCount;
        if (b) {
            this.updateTrafficStats((AbstractTaskBundleMessage)this.writeMessage);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobEntry(ServerTaskBundleNode bundle) {
        String uuid = bundle.getJob().getUuid();
        CollectionMap<String, Long> collectionMap = this.jobToBundlesIds;
        synchronized (collectionMap) {
            this.jobToBundlesIds.putValue((Object)uuid, (Object)bundle.getId());
            this.entryMap.put(uuid + bundle.getId(), bundle);
        }
    }

    public ServerTaskBundleNode getJobEntry(String uuid, long bundleId) {
        return this.entryMap.get(uuid + bundleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTaskBundleNode removeJobEntry(String uuid, long bundleId) {
        if (debugEnabled) {
            log.debug("removing job entry for uuid={}, bundleId={}", (Object)uuid, (Object)bundleId);
        }
        CollectionMap<String, Long> collectionMap = this.jobToBundlesIds;
        synchronized (collectionMap) {
            this.jobToBundlesIds.removeValue((Object)uuid, (Object)bundleId);
            return this.entryMap.remove(uuid + bundleId);
        }
    }

    private void updateTrafficStats(AbstractTaskBundleMessage message) {
        if (message != null) {
            double value;
            if (this.inSnapshot == null) {
                this.inSnapshot = this.driver.getStatistics().getSnapshot(this.peer ? "peer.traffic.in" : "node.traffic.in");
            }
            if (this.outSnapshot == null) {
                this.outSnapshot = this.driver.getStatistics().getSnapshot(this.peer ? "peer.traffic.out" : "node.traffic.out");
            }
            if ((value = (double)message.getChannelReadCount()) > 0.0) {
                this.inSnapshot.addValues(value, 1L);
            }
            if ((value = (double)message.getChannelWriteCount()) > 0.0) {
                this.outSnapshot.addValues(value, 1L);
            }
        }
    }

    AtomicBoolean getClosed() {
        return this.closed;
    }

    void offerMessageToSend(ServerTaskBundleNode bundle, AbstractTaskBundleMessage message) throws Exception {
        this.sendQueue.offer(message);
        if (!this.local) {
            this.server.updateInterestOps(this.getSelectionKey(), 4, true);
        }
    }

    protected AbstractTaskBundleMessage nextMessageToSend() {
        return (AbstractTaskBundleMessage)((Object)this.sendQueue.poll());
    }

    public AbstractTaskBundleMessage takeNextMessageToSend() throws InterruptedException {
        return this.sendQueue.take();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", peer=").append(this.peer);
        sb.append(", ssl=").append(this.ssl);
        sb.append(", local=").append(this.local);
        sb.append(", offline=").append(this.isOffline());
        sb.append(", maxJobs=").append(this.getMaxJobs());
        sb.append(", jobEntries=").append(this.entryMap.size());
        sb.append(", sendQueue size=").append(this.sendQueue.size());
        sb.append(", interestOps=").append(this.getInterestOps());
        sb.append(", executionStatus=").append(this.getExecutionStatus());
        sb.append(", socketChannel=").append(this.socketChannel);
        sb.append(']');
        return sb.toString();
    }

    public void close() {
        this.terminate();
    }

    boolean terminate() {
        boolean res = this.closed.compareAndSet(false, true);
        if (res) {
            if (debugEnabled) {
                log.debug("closing channel {}", (Object)this);
            }
            JMXDriverConnectionWrapper jmx = this.isPeer() ? this.getPeerJmxConnection() : this.getJmxConnection();
            this.setJmxConnection(null);
            this.setPeerJmxConnection(null);
            if (jmx != null) {
                ThreadUtils.startThread(() -> AsyncNodeContext.lambda$terminate$0((JMXConnectionWrapper)jmx), (String)("closing " + (Object)((Object)this)));
            }
            this.driver.getStatistics().addValue("nodes", -1.0);
            this.clear();
            this.sendQueue.clear();
            this.setExecutionStatus(ExecutorStatus.FAILED);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        CollectionMap<String, Long> collectionMap = this.jobToBundlesIds;
        synchronized (collectionMap) {
            this.jobToBundlesIds.clear();
            this.entryMap.clear();
        }
        this.sendQueue.clear();
    }

    public Object getMonitor() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentNbJobs() {
        CollectionMap<String, Long> collectionMap = this.jobToBundlesIds;
        synchronized (collectionMap) {
            return this.entryMap.size();
        }
    }

    public Future<?> submit(ServerTaskBundleNode nodeBundle) throws Exception {
        this.addJobEntry(nodeBundle);
        if (debugEnabled) {
            log.debug("submitting {} to {}", (Object)nodeBundle, (Object)this);
        }
        if (this.getCurrentNbJobs() >= this.getMaxJobs()) {
            this.setExecutionStatus(ExecutorStatus.EXECUTING);
        }
        nodeBundle.setOffline(this.isOffline());
        nodeBundle.setChannel(this);
        nodeBundle.getJob().setExecutionStartTime(System.nanoTime());
        AbstractTaskBundleMessage message = this.serializeBundle(nodeBundle);
        this.offerMessageToSend(nodeBundle, message);
        nodeBundle.checkTaskCount();
        return new AsyncNodeContextFuture(this, nodeBundle);
    }

    void cleanup() {
        Bundler<?> bundler;
        if (debugEnabled) {
            log.debug("handling cleanup for {}", (Object)this);
        }
        if (this.getReservationTansition() == NodeReservationHandler.Transition.REMOVE) {
            this.server.getNodeReservationHandler().removeReservation(this);
        }
        if ((bundler = this.getBundler()) != null) {
            bundler.dispose();
            if (bundler instanceof ContextAwareness) {
                ((ContextAwareness)bundler).setJPPFContext(null);
            }
        }
        this.setReadMessage(null);
    }

    void updateStatsUponTaskResubmit(int resubmittedTaskCount) {
        JPPFStatistics stats = this.server.getDriver().getStatistics();
        stats.addValue("task.queue.count", (double)resubmittedTaskCount);
    }

    public AsyncNodeNioServer getServer() {
        return this.server;
    }

    public ThreadSynchronization getLocalNodeReadLock() {
        return this.localNodeReadLock;
    }

    public ThreadSynchronization getLocalNodeWriteLock() {
        return this.localNodeWriteLock;
    }

    public int getMaxJobs() {
        return this.maxJobs.get();
    }

    public void setMaxJobs(int maxJobs) {
        this.maxJobs.set(maxJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbBundlesForJob(String jobUuid) {
        CollectionMap<String, Long> collectionMap = this.jobToBundlesIds;
        synchronized (collectionMap) {
            Collection bundleIds = this.jobToBundlesIds.getValues((Object)jobUuid);
            return bundleIds == null ? 0 : bundleIds.size();
        }
    }

    public boolean isAcceptingNewJobs() {
        return this.acceptingNewJobs.get();
    }

    public void setAcceptingNewJobs(boolean acceptingNewJobs) {
        if (debugEnabled) {
            log.debug("node is {}accepting new jobs: {}", (Object)(acceptingNewJobs ? "" : "not "), (Object)this);
        }
        this.acceptingNewJobs.set(acceptingNewJobs);
    }

    private static /* synthetic */ void lambda$terminate$0(JMXConnectionWrapper jmx) {
        jmx.close();
    }
}

