/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver.async;

import java.util.concurrent.FutureTask;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeContextFuture
extends FutureTask<Object> {
    private static Logger log = LoggerFactory.getLogger(AsyncNodeContextFuture.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final AsyncNodeContext context;
    private final ServerTaskBundleNode bundle;
    private static final Runnable NOOP_RUNNABLE = () -> {};

    public AsyncNodeContextFuture(AsyncNodeContext context, ServerTaskBundleNode bundle) {
        super(NOOP_RUNNABLE, null);
        this.context = context;
        this.bundle = bundle;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (debugEnabled) {
            log.debug("cancelling {}, isCancelled()={}", (Object)this.context, (Object)this.isCancelled());
        }
        if (this.isCancelled()) {
            return true;
        }
        if (this.isDone()) {
            return false;
        }
        if (this.bundle == null) {
            return false;
        }
        try {
            this.bundle.cancel();
            this.context.cancelJob(this.bundle.getClientJob().getUuid(), false);
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)e));
        }
        finally {
            return super.cancel(false);
        }
    }
}

