/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.nodeserver.async;

import org.jppf.nio.NioMessage;
import org.jppf.nio.NioMessageWriter;
import org.jppf.nio.StatelessNioServer;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.nio.AbstractTaskBundleMessage;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNodeMessageWriter
extends NioMessageWriter<AsyncNodeContext> {
    private static final Logger log = LoggerFactory.getLogger(AsyncNodeMessageWriter.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    public AsyncNodeMessageWriter(StatelessNioServer<AsyncNodeContext> server) {
        super(server);
    }

    protected void preWrite(AsyncNodeContext context, NioMessage data) throws Exception {
        TaskBundle header = ((AbstractTaskBundleMessage)data).getBundle();
        if (debugEnabled) {
            log.debug("before sending message {} for job [uuid={}, name={}, handshake={}] from context {}", new Object[]{data, header.getUuid(), header.getName(), header.isHandshake(), context});
        }
        if (!header.isHandshake()) {
            ServerTaskBundleNode nodeBundle = context.getJobEntry(header.getUuid(), header.getBundleId());
            if (nodeBundle == null) {
                log.warn("null nodeBundle for header = {}, context = {}, data = {}", new Object[]{header, context, data});
            }
            context.getServer().getMessageHandler().beforeSendingBundle(context, nodeBundle);
        }
    }

    protected void postWrite(AsyncNodeContext context, NioMessage data) throws Exception {
        AbstractTaskBundleMessage msg = (AbstractTaskBundleMessage)data;
        TaskBundle header = msg.getBundle();
        if (debugEnabled) {
            log.debug("fully sent message {} for job [uuid={}, name={}, handshake={}] from context {}", new Object[]{data, header.getUuid(), header.getName(), header.isHandshake(), context});
        }
        if (!header.isHandshake()) {
            ServerTaskBundleNode nodeBundle = context.getJobEntry(header.getUuid(), header.getBundleId());
            context.getServer().getMessageHandler().bundleSent(context, nodeBundle);
        }
    }
}

