/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node.local;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jppf.JPPFUnsupportedOperationException;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.io.DataLocation;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.nio.nodeserver.LocalNodeMessage;
import org.jppf.server.node.AbstractCommonNode;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.ObjectDeserializationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFLocalContainer
extends JPPFContainer {
    private static Logger log = LoggerFactory.getLogger(JPPFLocalContainer.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public JPPFLocalContainer(AbstractCommonNode node, List<String> uuidPath, AbstractJPPFClassLoader classLoader, boolean clientAccess) throws Exception {
        super(node, uuidPath, classLoader, clientAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deserializeObjects(Object[] list, int count, LocalNodeMessage currentMessage, ExecutorService executor) throws Exception {
        if (debugEnabled) {
            log.debug("deserializing {} objects", (Object)count);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            int i;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            ExecutorCompletionService completionService = new ExecutorCompletionService(executor, new ArrayBlockingQueue(count));
            List locations = currentMessage.getLocations();
            for (i = 0; i < count; ++i) {
                completionService.submit(new ObjectDeserializationTask((JPPFContainer)this, (TaskBundle)list[0], (DataLocation)locations.get(i + 1), i));
            }
            for (i = 0; i < count; ++i) {
                Future f = completionService.take();
                ObjectDeserializationTask task = (ObjectDeserializationTask)f.get();
                list[task.getIndex() + 1] = task.getObject();
            }
            int n = 0;
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public int deserializeObjects(Object[] list, int count, ExecutorService executor) throws Exception {
        throw new JPPFUnsupportedOperationException("method " + ((Object)((Object)this)).getClass().getName() + ".deserializeObjects(Object[], int, ExecutorService) should never be called for a local node");
    }
}

